/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.botanicadds.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.zeith.botanicadds.init.BlocksBA;
import org.zeith.botanicadds.init.RecipeTypesBA;
import org.zeith.hammerlib.api.recipes.BaseRecipe;
import org.zeith.hammerlib.api.recipes.SerializableRecipeType;
import vazkii.botania.api.recipe.TerrestrialAgglomerationRecipe;
import vazkii.botania.common.crafting.recipe.RecipeUtils;

public class RecipeGaiaPlate
extends BaseRecipe<RecipeGaiaPlate>
implements TerrestrialAgglomerationRecipe {
    private final int mana;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;

    public RecipeGaiaPlate(ResourceLocation id, String group, int mana, NonNullList<Ingredient> inputs, ItemStack output) {
        super(id, group);
        this.mana = mana;
        this.inputs = inputs;
        this.output = output;
    }

    public int getMana() {
        return this.mana;
    }

    public boolean m_5818_(Container inv, @NotNull Level world) {
        int nonEmptySlots = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            if (inv.m_8020_(i).m_41619_()) continue;
            if (inv.m_8020_(i).m_41613_() > 1) {
                return false;
            }
            ++nonEmptySlots;
        }
        IntOpenHashSet usedSlots = new IntOpenHashSet(inv.m_6643_());
        return RecipeUtils.matches(this.inputs, (Container)inv, (IntSet)usedSlots) && usedSlots.size() == nonEmptySlots;
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container inv) {
        return this.output.m_41777_();
    }

    @NotNull
    public ItemStack m_8043_() {
        return this.output;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    protected SerializableRecipeType<RecipeGaiaPlate> getRecipeType() {
        return RecipeTypesBA.GAIA_PLATE;
    }

    public ItemStack m_8042_() {
        return BlocksBA.GAIA_PLATE.m_5456_().m_7968_();
    }

    public static class GaiaPlateRecipeType
    extends SerializableRecipeType<RecipeGaiaPlate> {
        @NotNull
        public RecipeGaiaPlate fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            int mana = GsonHelper.m_13927_((JsonObject)json, (String)"mana");
            JsonArray ingrs = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            Object[] ingredients = new Ingredient[ingrs.size()];
            for (int i = 0; i < ingrs.size(); ++i) {
                ingredients[i] = Ingredient.m_43917_((JsonElement)ingrs.get(i));
            }
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new RecipeGaiaPlate(recipeId, group, mana, (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])ingredients), output);
        }

        public RecipeGaiaPlate fromNetwork(@NotNull ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int mana = buffer.m_130242_();
            Object[] ingredients = new Ingredient[buffer.m_130242_()];
            for (int i = 0; i < ingredients.length; ++i) {
                ingredients[i] = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            }
            ItemStack output = buffer.m_130267_();
            String group = buffer.m_130277_();
            return new RecipeGaiaPlate(recipeId, group, mana, (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])ingredients), output);
        }

        public void toNetwork(FriendlyByteBuf buffer, RecipeGaiaPlate recipe) {
            buffer.m_130130_(recipe.mana);
            buffer.m_130130_(recipe.m_7527_().size());
            for (Ingredient ingr : recipe.m_7527_()) {
                ingr.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.output);
            buffer.m_130070_(recipe.group);
        }
    }
}

