/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.botanicadds.tiles;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeith.botanicadds.api.tile.IElvenBrewery;
import org.zeith.botanicadds.init.TilesBA;
import org.zeith.botanicadds.util.SparkUtil;
import org.zeith.hammerlib.api.forge.BlockAPI;
import org.zeith.hammerlib.util.java.Cast;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.spark.ManaSpark;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.block_entity.BreweryBlockEntity;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.helper.EntityHelper;

public class TileElvenBrewery
extends BreweryBlockEntity
implements SparkAttachable,
IElvenBrewery {
    private static final int CRAFT_EFFECT_EVENT = 0;
    protected int manaLastTick = 0;
    private final LazyOptional<SparkAttachable> spark = LazyOptional.of(() -> this);

    public TileElvenBrewery(BlockPos pos, BlockState state) {
        super(pos, state);
        BlockAPI.spoofBlockEntityType((BlockEntity)this, TilesBA.ELVEN_BREWERY);
    }

    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    public int getAvailableSpaceForMana() {
        return Math.max(0, this.getManaCost() - this.getCurrentMana());
    }

    public ManaSpark getAttachedSpark() {
        List sparks = this.f_58857_.m_6443_(Entity.class, new AABB(this.f_58858_.m_7494_(), this.f_58858_.m_7494_().m_7918_(1, 1, 1)), (Predicate)Predicates.instanceOf(ManaSpark.class));
        if (sparks.size() == 1) {
            return (ManaSpark)Cast.cast(sparks.get(0));
        }
        return null;
    }

    public boolean areIncomingTranfersDone() {
        return !this.canReceiveManaFromBursts();
    }

    public void receiveMana(int mana) {
        super.receiveMana(mana);
        if (mana != 0) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers((BlockEntity)this);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == BotaniaForgeCapabilities.SPARK_ATTACHABLE) {
            return BotaniaForgeCapabilities.SPARK_ATTACHABLE.orEmpty(cap, this.spark);
        }
        return super.getCapability(cap, side);
    }

    protected void findRecipeElven() {
        Optional maybeRecipe = this.f_58857_.m_7465_().m_44015_(BotaniaRecipeTypes.BREW_TYPE, this.getItemHandler(), this.f_58857_);
        maybeRecipe.ifPresent(recipeBrew -> {
            this.recipe = recipeBrew;
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)));
        });
    }

    public static void commonTickElven(Level level, BlockPos worldPosition, BlockState state, TileElvenBrewery self) {
        if (self.getCurrentMana() > 0 && self.recipe == null) {
            self.findRecipeElven();
            if (self.recipe == null) {
                self.receiveMana(-self.getCurrentMana());
            }
        }
        self.receiveMana(0);
        if (!level.f_46443_ && self.recipe == null) {
            List items = level.m_45976_(ItemEntity.class, new AABB((double)worldPosition.m_123341_(), (double)worldPosition.m_123342_(), (double)worldPosition.m_123343_(), (double)(worldPosition.m_123341_() + 1), (double)(worldPosition.m_123342_() + 1), (double)(worldPosition.m_123343_() + 1)));
            for (ItemEntity item : items) {
                ItemStack stack;
                if (!item.m_6084_() || item.m_32055_().m_41619_() || !self.addItem(null, stack = item.m_32055_(), null)) continue;
                EntityHelper.syncItem((ItemEntity)item);
            }
        }
        if (self.recipe != null) {
            if (!self.recipe.m_5818_(self.getItemHandler(), level)) {
                self.recipe = null;
                level.m_46597_(worldPosition, self.m_58900_().m_60734_().m_49966_());
            }
            if (self.recipe != null) {
                if (self.getCurrentMana() != self.manaLastTick) {
                    int color = self.recipe.getBrew().getColor(self.getItemHandler().m_8020_(0));
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    for (int i = 0; i < 5; ++i) {
                        WispParticleData data1 = WispParticleData.wisp((float)(0.1f + (float)Math.random() * 0.05f), (float)r, (float)g, (float)b);
                        level.m_7106_((ParticleOptions)data1, (double)worldPosition.m_123341_() + 0.7 - Math.random() * 0.4, (double)worldPosition.m_123342_() + 0.9 - Math.random() * 0.2, (double)worldPosition.m_123343_() + 0.7 - Math.random() * 0.4, (double)(0.03f - (float)Math.random() * 0.06f), (double)(0.03f + (float)Math.random() * 0.015f), (double)(0.03f - (float)Math.random() * 0.06f));
                        for (int j = 0; j < 2; ++j) {
                            WispParticleData data = WispParticleData.wisp((float)(0.1f + (float)Math.random() * 0.2f), (float)0.2f, (float)0.2f, (float)0.2f);
                            level.m_7106_((ParticleOptions)data, (double)worldPosition.m_123341_() + 0.7 - Math.random() * 0.4, (double)worldPosition.m_123342_() + 0.9 - Math.random() * 0.2, (double)worldPosition.m_123343_() + 0.7 - Math.random() * 0.4, (double)(0.03f - (float)Math.random() * 0.06f), (double)(0.03f + (float)Math.random() * 0.015f), (double)(0.03f - (float)Math.random() * 0.06f));
                        }
                    }
                }
                if (self.getCurrentMana() >= self.getManaCost() && !level.f_46443_) {
                    int mana = self.getManaCost();
                    self.receiveMana(-mana);
                    ItemStack output = self.recipe.getOutput(self.getItemHandler().m_8020_(0));
                    ItemEntity outputItem = new ItemEntity(level, (double)worldPosition.m_123341_() + 0.5, (double)worldPosition.m_123342_() + 1.5, (double)worldPosition.m_123343_() + 0.5, output);
                    level.m_7967_((Entity)outputItem);
                    level.m_7696_(worldPosition, self.m_58900_().m_60734_(), 0, self.recipe.getBrew().getColor(output));
                    for (int i = 0; i < self.inventorySize(); ++i) {
                        self.getItemHandler().m_6836_(i, ItemStack.f_41583_);
                    }
                }
            }
        }
        int newSignal = 0;
        if (self.recipe != null) {
            ++newSignal;
        }
        if (newSignal != self.signal) {
            self.signal = newSignal;
            level.m_46717_(worldPosition, state.m_60734_());
        }
        self.manaLastTick = self.getCurrentMana();
        if (self.getManaCost() > 0) {
            SparkUtil.startRequestingMana((BlockEntity)self, self.getAttachedSpark());
        }
    }
}

