/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.base;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.melanx.botanicalmachinery.blocks.base.BotanicalTile;
import de.melanx.botanicalmachinery.gui.ManaBar;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.moddingx.libx.menu.BlockEntityMenu;

public abstract class ScreenBase<X extends BlockEntityMenu<?>>
extends AbstractContainerScreen<X> {
    public final ManaBar manaBar;
    public int relX;
    public int relY;

    public ScreenBase(X menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        BlockEntity blockEntity = ((BlockEntityMenu)this.f_97732_).getBlockEntity();
        if (blockEntity instanceof BotanicalTile) {
            BotanicalTile botanicalTile = (BotanicalTile)blockEntity;
            this.manaBar = new ManaBar((Screen)this, botanicalTile.getMaxMana());
        } else {
            this.manaBar = new ManaBar((Screen)this, 0);
        }
    }

    public void m_6575_(@Nonnull Minecraft minecraft, int width, int height) {
        super.m_6575_(minecraft, width, height);
        this.relX = (width - this.f_97726_) / 2;
        this.relY = (height - this.f_97727_) / 2;
    }

    public void m_6305_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.manaBar.guiTop = this.f_97736_;
        this.manaBar.guiLeft = this.f_97735_;
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.m_7025_(poseStack, mouseX, mouseY);
        BlockEntity blockEntity = ((BlockEntityMenu)this.f_97732_).getBlockEntity();
        if (blockEntity instanceof BotanicalTile) {
            BotanicalTile botanicalTile = (BotanicalTile)blockEntity;
            this.manaBar.renderHoveredToolTip(poseStack, mouseX, mouseY, botanicalTile.getCurrentMana());
        }
    }

    protected void m_7027_(@Nonnull PoseStack poseStack, int mouseX, int mouseY) {
        String s = this.f_96539_.getString();
        this.f_96547_.m_92883_(poseStack, s, (float)(this.f_97726_ / 2 - this.f_96547_.m_92895_(s) / 2), 6.0f, Color.DARK_GRAY.getRGB());
        this.f_96547_.m_92883_(poseStack, this.f_169604_.getString(), 8.0f, (float)(this.f_97727_ - 96 + 2), Color.DARK_GRAY.getRGB());
    }

    public void drawDefaultGuiBackgroundLayer(PoseStack poseStack, ResourceLocation screenLocation) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)screenLocation);
        this.m_93228_(poseStack, this.relX, this.relY, 0, 0, this.f_97726_, this.f_97727_);
        BlockEntity blockEntity = ((BlockEntityMenu)this.f_97732_).getBlockEntity();
        if (blockEntity instanceof BotanicalTile) {
            BotanicalTile botanicalTile = (BotanicalTile)blockEntity;
            this.manaBar.draw(poseStack, botanicalTile.getCurrentMana());
        }
    }
}

