/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.tesr;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import de.melanx.botanicalmachinery.blocks.tiles.BlockEntityMechanicalApothecary;
import de.melanx.botanicalmachinery.config.LibXClientConfig;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.moddingx.libx.render.RenderHelper;
import org.moddingx.libx.render.block.RotatedBlockRenderer;
import vazkii.botania.client.core.handler.ClientTickHandler;

public class MechanicalApothecaryRenderer
extends RotatedBlockRenderer<BlockEntityMechanicalApothecary> {
    protected void doRender(@Nonnull BlockEntityMechanicalApothecary tile, float partialTick, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        if (!LibXClientConfig.AdvancedRendering.all || !LibXClientConfig.AdvancedRendering.mechanicalApothecary) {
            return;
        }
        if (!tile.getInventory().getStackInSlot(0).m_41619_()) {
            float time = (float)ClientTickHandler.ticksInGame + partialTick;
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.89375, 0.5);
            poseStack.m_85841_(0.375f, 0.375f, 0.375f);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(time / 1.3f));
            ItemStack stack = tile.getInventory().getStackInSlot(0);
            if (tile.getProgress() > 0) {
                int progress = tile.getProgress();
                if (progress > tile.getMaxProgress() / 2) {
                    progress = tile.getMaxProgress() / 2 - Math.abs(tile.getMaxProgress() / 2 - progress);
                    stack = tile.getCurrentOutput();
                }
                double amount = (double)progress / ((double)tile.getMaxProgress() / 2.0);
                poseStack.m_85837_(0.0, -amount, 0.0);
            }
            Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.GROUND, light, OverlayTexture.f_118083_, poseStack, buffer, (int)tile.m_58899_().m_121878_());
            poseStack.m_85849_();
        }
        double fluidAmount = ((double)tile.getFluidInventory().getFluidAmount() - (double)tile.getProgress() / (double)(tile.getMaxProgress() == 0 ? 1 : tile.getMaxProgress()) * 1000.0) / (double)tile.getFluidInventory().getCapacity();
        if (tile.getFluidInventory().getFluidAmount() > 0) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.25, (10.0 + fluidAmount * 3.8) / 16.0, 0.25);
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            poseStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
            FluidStack fluidStack = tile.getFluidInventory().getFluid();
            IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidTypeExtensions.getStillTexture(fluidStack));
            int fluidColor = fluidTypeExtensions.getTintColor(fluidStack);
            VertexConsumer vertex = buffer.m_6299_(Sheets.m_110792_());
            RenderHelper.renderIconColored((PoseStack)poseStack, (VertexConsumer)vertex, (float)0.0f, (float)0.0f, (TextureAtlasSprite)sprite, (float)8.0f, (float)8.0f, (float)1.0f, (int)fluidColor, (int)light, (int)OverlayTexture.f_118083_);
            poseStack.m_85849_();
        }
        int items = 0;
        for (int slot = 1; slot < 17; ++slot) {
            if (tile.getInventory().getStackInSlot(slot).m_41619_()) continue;
            ++items;
        }
        double offsetPerPetal = 360.0 / (double)items;
        double flowerTicks = (double)((float)ClientTickHandler.ticksInGame + partialTick) / 2.0;
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, (10.0 + fluidAmount * 3.8 / 1.5) / 16.0, 0.5);
        poseStack.m_85841_(0.125f, 0.125f, 0.125f);
        int nextIdx = 0;
        boolean hasFluid = tile.getFluidInventory().getFluidAmount() > 0;
        for (int slot = 1; slot < 17; ++slot) {
            double radiusZ;
            double radiusX;
            if (tile.getInventory().getStackInSlot(slot).m_41619_()) continue;
            int i = nextIdx++;
            double offset = offsetPerPetal * (double)i;
            double deg = hasFluid ? flowerTicks / 0.25 % 360.0 + offset : offset;
            double rad = deg * Math.PI / 180.0;
            if (hasFluid) {
                radiusX = (double)1.2f + (double)0.1f * Math.sin(flowerTicks / 6.0);
                radiusZ = (double)1.2f + (double)0.1f * Math.cos(flowerTicks / 6.0);
            } else {
                radiusX = 1.300000049173832;
                radiusZ = 1.300000049173832;
            }
            double x = radiusX * Math.cos(rad);
            double z = radiusZ * Math.sin(rad);
            double y = hasFluid ? (double)((float)Math.cos((flowerTicks + (double)(50 * i)) / 5.0) / 10.0f) : 0.0;
            poseStack.m_85836_();
            poseStack.m_85837_(x, y, z);
            poseStack.m_85837_(0.0625, 0.0625, 0.0625);
            if (hasFluid) {
                float xRotate = (float)Math.sin(flowerTicks * 0.25) / 2.0f;
                float yRotate = (float)Math.max((double)0.6f, Math.sin(flowerTicks * (double)0.1f) / 2.0 + 0.5);
                float zRotate = (float)Math.cos(flowerTicks * 0.25) / 2.0f;
                poseStack.m_85845_(new Vector3f(xRotate, yRotate, zRotate).m_122240_((float)deg));
            } else {
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            }
            poseStack.m_85837_(-0.0625, -0.0625, -0.0625);
            ItemStack stack = tile.getInventory().getStackInSlot(slot);
            Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.GROUND, light, overlay, poseStack, buffer, (int)tile.m_58899_().m_121878_() + slot);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }
}

