/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.tiles;

import de.melanx.botanicalmachinery.config.LibXClientConfig;
import de.melanx.botanicalmachinery.config.LibXServerConfig;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.moddingx.libx.base.tile.BlockEntityBase;
import org.moddingx.libx.base.tile.TickingBlock;
import org.moddingx.libx.capability.ItemCapabilities;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.recipe.PureDaisyRecipe;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;

public class BlockEntityMechanicalDaisy
extends BlockEntityBase
implements TickingBlock {
    private int ticksToNextUpdate = 5;
    private int[] workingTicks = new int[8];
    private final InventoryHandler inventory = new InventoryHandler();
    private final LazyOptional<IItemHandlerModifiable> lazyInventory = ItemCapabilities.create((IItemHandlerModifiable)this.inventory).cast();
    private final LazyOptional<IItemHandlerModifiable> hopperInventory = ItemCapabilities.create((IItemHandlerModifiable)this.inventory, slot -> this.workingTicks[slot] < 0, null).cast();
    private final LazyOptional<IFluidHandler> fluidInventory = LazyOptional.of(() -> this.inventory);

    public BlockEntityMechanicalDaisy(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("inv")) {
            this.inventory.deserializeNBT(nbt.m_128469_("inv"));
        }
        if (nbt.m_128441_("workingTicks")) {
            this.workingTicks = nbt.m_128465_("workingTicks");
        }
    }

    public void tick() {
        boolean hasSpawnedParticles = false;
        for (int i = 0; i < 8; ++i) {
            PureDaisyRecipe recipe = this.getRecipe(i);
            if (recipe != null) {
                if (!this.f_58857_.f_46443_) {
                    if (this.workingTicks[i] >= recipe.getTime() * LibXServerConfig.WorkingDurationMultiplier.mechanicalDaisy) {
                        BlockState state = recipe.getOutputState();
                        if (state.m_60734_().m_5456_() != Items.f_41852_) {
                            this.inventory.setStackInSlot(i, state.m_60734_().m_7397_((BlockGetter)this.f_58857_, this.f_58858_, state));
                        } else if (state.m_60819_().m_76152_() != Fluids.f_76191_) {
                            this.inventory.setStackInSlot(i, new FluidStack(state.m_60819_().m_76152_(), 1000));
                        }
                        this.workingTicks[i] = -1;
                        this.setDispatchable();
                        continue;
                    }
                    int n = i;
                    this.workingTicks[n] = this.workingTicks[n] + 1;
                    continue;
                }
                if (hasSpawnedParticles || !LibXClientConfig.AdvancedRendering.all || !LibXClientConfig.AdvancedRendering.mechanicalDaisy) continue;
                hasSpawnedParticles = true;
                double x = (double)this.f_58858_.m_123341_() + Math.random();
                double y = (double)this.f_58858_.m_123342_() + Math.random() + 0.25;
                double z = (double)this.f_58858_.m_123343_() + Math.random();
                WispParticleData data = WispParticleData.wisp((float)((float)Math.random() / 2.0f), (float)1.0f, (float)1.0f, (float)1.0f);
                this.f_58857_.m_7106_((ParticleOptions)data, x, y, z, 0.0, 0.0, 0.0);
                continue;
            }
            this.workingTicks[i] = this.workingTicks[i] < 0 && !this.inventory.getStackInSlot(i).m_41619_() ? -1 : 0;
        }
        if (!this.f_58857_.f_46443_) {
            if (this.ticksToNextUpdate <= 0) {
                this.ticksToNextUpdate = 5;
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers((BlockEntity)this);
            } else {
                --this.ticksToNextUpdate;
            }
        }
    }

    @Nullable
    private PureDaisyRecipe getRecipe(int slot) {
        BlockState state = this.getState(slot);
        if (state == null) {
            return null;
        }
        return this.getRecipe(state);
    }

    @Nullable
    public BlockState getState(int slot) {
        BlockState state = null;
        ItemStack stack = this.inventory.getStackInSlot(slot);
        if (!stack.m_41619_()) {
            if (stack.m_41720_() instanceof BlockItem) {
                state = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
            }
        } else {
            FluidStack fluid = this.inventory.getFluidInTank(slot);
            if (!fluid.isEmpty() && fluid.getAmount() >= 1000) {
                state = fluid.getFluid().m_76145_().m_76188_();
            }
        }
        return state;
    }

    @Nullable
    public PureDaisyRecipe getRecipe(BlockState state) {
        if (this.f_58857_ == null) {
            return null;
        }
        for (Recipe genericRecipe : this.f_58857_.m_7465_().m_44013_(BotaniaRecipeTypes.PURE_DAISY_TYPE)) {
            PureDaisyRecipe recipe;
            if (!(genericRecipe instanceof PureDaisyRecipe) || !(recipe = (PureDaisyRecipe)genericRecipe).matches(this.f_58857_, this.f_58858_, null, state)) continue;
            return recipe;
        }
        return null;
    }

    public InventoryHandler getInventory() {
        return this.inventory;
    }

    @Nonnull
    public <X> LazyOptional<X> getCapability(@Nonnull Capability<X> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            return side == null ? this.lazyInventory : this.hopperInventory;
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidInventory;
        }
        return super.getCapability(cap, side);
    }

    public void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        nbt.m_128385_("workingTicks", this.workingTicks);
    }

    public void handleUpdateTag(CompoundTag nbt) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            return;
        }
        super.handleUpdateTag(nbt);
        if (nbt.m_128441_("inv")) {
            this.inventory.deserializeNBT(nbt.m_128469_("inv"));
        }
        if (nbt.m_128441_("workingTicks")) {
            this.workingTicks = nbt.m_128465_("workingTicks");
        }
    }

    @Nonnull
    public CompoundTag m_5995_() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            return super.m_5995_();
        }
        CompoundTag nbt = super.m_5995_();
        nbt.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        nbt.m_128385_("workingTicks", this.workingTicks);
        return nbt;
    }

    public class InventoryHandler
    extends ItemStackHandler
    implements IFluidHandler {
        private final List<FluidStack> fluids;

        public InventoryHandler() {
            super(8);
            this.fluids = new ArrayList<FluidStack>(8);
            for (int i = 0; i < 8; ++i) {
                this.fluids.add(FluidStack.EMPTY);
            }
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            if (!stack.m_41619_()) {
                this.fluids.set(slot, FluidStack.EMPTY);
            }
            super.setStackInSlot(slot, stack);
        }

        public void setStackInSlot(int slot, @Nonnull FluidStack stack) {
            this.fluids.set(slot, stack);
            if (!stack.isEmpty()) {
                super.setStackInSlot(slot, ItemStack.f_41583_);
            } else {
                this.onContentsChanged(slot);
            }
        }

        public int getSlots() {
            return 8;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.fluids.get(slot).isEmpty()) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!this.fluids.get(slot).isEmpty()) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return !stack.m_41619_() && stack.m_41720_() instanceof BlockItem && BlockEntityMechanicalDaisy.this.getRecipe(((BlockItem)stack.m_41720_()).m_40614_().m_49966_()) != null;
        }

        public int getTanks() {
            return 8;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            if (!this.getStackInSlot(tank).m_41619_()) {
                return FluidStack.EMPTY;
            }
            return this.fluids.get(tank);
        }

        public int getTankCapacity(int tank) {
            return 1000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return !stack.isEmpty() && BlockEntityMechanicalDaisy.this.getRecipe(stack.getFluid().m_76145_().m_76188_()) != null;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            int transfer;
            int i;
            int leftToFill = resource.getAmount();
            for (i = 0; i < 8 && leftToFill > 0; ++i) {
                if (!this.getStackInSlot(i).m_41619_() || this.fluids.get(i).getFluid() != resource.getFluid()) continue;
                transfer = Math.min(leftToFill, this.getTankCapacity(i) - this.fluids.get(i).getAmount());
                leftToFill -= transfer;
                if (action != IFluidHandler.FluidAction.EXECUTE) continue;
                this.fluids.get(i).setAmount(this.fluids.get(i).getAmount() + transfer);
                this.onContentsChanged(i);
            }
            for (i = 0; i < 8 && leftToFill > 0; ++i) {
                if (!this.getStackInSlot(i).m_41619_() || !this.fluids.get(i).isEmpty()) continue;
                transfer = Math.min(leftToFill, this.getTankCapacity(i));
                leftToFill -= transfer;
                if (action != IFluidHandler.FluidAction.EXECUTE) continue;
                this.fluids.set(i, new FluidStack(resource.getFluid(), transfer));
                this.onContentsChanged(i);
            }
            return resource.getAmount() - leftToFill;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            int leftToDrain = resource.getAmount();
            for (int i = 0; i < 8 && leftToDrain > 0; ++i) {
                if (!this.getStackInSlot(i).m_41619_() || this.fluids.get(i).getFluid() != resource.getFluid()) continue;
                int transfer = Math.min(this.fluids.get(i).getAmount(), leftToDrain);
                leftToDrain -= transfer;
                if (action != IFluidHandler.FluidAction.EXECUTE) continue;
                this.fluids.get(i).setAmount(this.fluids.get(i).getAmount() - transfer);
                if (this.fluids.get(i).getAmount() <= 0) {
                    this.fluids.set(i, FluidStack.EMPTY);
                }
                this.onContentsChanged(i);
            }
            if (resource.getAmount() - leftToDrain > 0) {
                return new FluidStack(resource.getFluid(), resource.getAmount() - leftToDrain);
            }
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            int leftToDrain = maxDrain;
            Fluid drainFluid = null;
            for (int i = 0; i < 8 && leftToDrain > 0; ++i) {
                if (!this.getStackInSlot(i).m_41619_() || drainFluid != null && drainFluid != this.fluids.get(i).getFluid()) continue;
                int transfer = Math.min(this.fluids.get(i).getAmount(), leftToDrain);
                leftToDrain -= transfer;
                if (transfer > 0) {
                    drainFluid = this.fluids.get(i).getFluid();
                }
                if (action != IFluidHandler.FluidAction.EXECUTE) continue;
                this.fluids.get(i).setAmount(this.fluids.get(i).getAmount() - transfer);
                if (this.fluids.get(i).getAmount() <= 0) {
                    this.fluids.set(i, FluidStack.EMPTY);
                }
                this.onContentsChanged(i);
            }
            if (drainFluid == null) {
                return FluidStack.EMPTY;
            }
            return new FluidStack(drainFluid, maxDrain - leftToDrain);
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = super.serializeNBT();
            ListTag tag = new ListTag();
            for (int i = 0; i < 8; ++i) {
                CompoundTag fluidNbt = new CompoundTag();
                this.fluids.get(i).writeToNBT(fluidNbt);
                tag.add(i, (Tag)fluidNbt);
            }
            nbt.m_128365_("fluids", (Tag)tag);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            super.deserializeNBT(nbt);
            if (nbt.m_128441_("fluids")) {
                ListTag tag = nbt.m_128437_("fluids", 10);
                for (int i = 0; i < 8; ++i) {
                    CompoundTag fluidNbt = tag.m_128728_(i);
                    this.fluids.set(i, FluidStack.loadFluidStackFromNBT((CompoundTag)fluidNbt));
                }
            }
        }

        protected void onContentsChanged(int slot) {
            BlockEntityMechanicalDaisy.this.m_6596_();
            BlockEntityMechanicalDaisy.this.setDispatchable();
        }
    }
}

