/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.botanypotstiers.block;

import com.ultramega.botanypotstiers.PotTiers;
import com.ultramega.botanypotstiers.block.TieredBlockEntityBotanyPot;
import java.util.Random;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.registry.RegistryObject;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.block.BlockBotanyPot;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.data.recipes.crop.Crop;
import net.darkhax.botanypots.data.recipes.fertilizer.Fertilizer;
import net.darkhax.botanypots.data.recipes.potinteraction.PotInteraction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;

public class TieredBlockBotanyPot
extends BlockBotanyPot {
    private static final BlockBehaviour.Properties DEFAULT_PROPERTIES = BlockBehaviour.Properties.m_60944_((Material)Material.f_76313_, (MaterialColor)MaterialColor.f_76413_).m_60913_(1.25f, 4.2f).m_60955_().m_60953_(state -> (Integer)state.m_61143_((Property)BlockStateProperties.f_61422_));
    public final PotTiers tier;

    public TieredBlockBotanyPot(PotTiers tier, boolean hasInventory) {
        this(tier, DEFAULT_PROPERTIES, hasInventory);
    }

    public TieredBlockBotanyPot(PotTiers tier, BlockBehaviour.Properties properties, boolean hasInventory) {
        super(hasInventory);
        BlockState defaultState = (BlockState)this.m_49965_().m_61090_();
        defaultState = (BlockState)defaultState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
        defaultState = (BlockState)defaultState.m_61124_((Property)BlockStateProperties.f_61422_, (Comparable)Integer.valueOf(0));
        defaultState = (BlockState)defaultState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH);
        this.m_49959_(defaultState);
        this.tier = tier;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        int n;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TieredBlockEntityBotanyPot) {
            TieredBlockEntityBotanyPot pot = (TieredBlockEntityBotanyPot)blockEntity;
            n = pot.getComparatorLevel();
        } else {
            n = 0;
        }
        return n;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TieredBlockEntityBotanyPot(this.tier, pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TieredBlockEntityBotanyPot) {
            Fertilizer fertilizer;
            TieredBlockEntityBotanyPot potEntity = (TieredBlockEntityBotanyPot)blockEntity;
            ItemStack heldStack = player.m_21120_(hand);
            if (potEntity.areGrowthConditionsMet() && potEntity.getGrowthTime() > 0 && !potEntity.getDoneGrowing() && (fertilizer = BotanyPotHelper.findFertilizer((BlockState)state, (Level)world, (BlockPos)pos, (Player)player, (InteractionHand)hand, (ItemStack)heldStack, (BlockEntityBotanyPot)potEntity)) != null) {
                fertilizer.apply(state, world, pos, player, hand, heldStack, (BlockEntityBotanyPot)potEntity);
                return InteractionResult.CONSUME;
            }
            PotInteraction interaction = BotanyPotHelper.findPotInteraction((BlockState)state, (Level)world, (BlockPos)pos, (Player)player, (InteractionHand)hand, (ItemStack)heldStack, (BlockEntityBotanyPot)potEntity);
            if (interaction != null) {
                interaction.apply(state, world, pos, player, hand, heldStack, (BlockEntityBotanyPot)potEntity);
                return InteractionResult.CONSUME;
            }
            if (!player.m_6047_() && !potEntity.isHopper() && potEntity.getDoneGrowing() && potEntity.getCrop() != null) {
                if (!world.f_46443_) {
                    for (ItemStack drop : BotanyPotHelper.generateDrop((Random)potEntity.rng, (Level)world, (BlockPos)pos, (BlockEntityBotanyPot)potEntity, (Crop)potEntity.getCrop())) {
                        drop.m_41764_(drop.m_41613_() * this.tier.getMultiplier());
                        TieredBlockBotanyPot.m_49840_((Level)world, (BlockPos)pos, (ItemStack)drop);
                    }
                    potEntity.resetGrowth();
                }
                return InteractionResult.CONSUME;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Services.INVENTORY_HELPER.openMenu(serverPlayer, (MenuProvider)potEntity, buf -> Serializers.BLOCK_POS.toByteBuf(buf, (Object)pos));
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hitResult);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level worldLevel, BlockState state, BlockEntityType<T> blockEntityType) {
        return TieredBlockBotanyPot.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)RegistryObject.deferred((Registry)Registry.f_122830_, (String)"botanypotstiers", (String)(this.tier.getName() + "_botany_pot")).cast().get()), (level, pos, state1, pot) -> TieredBlockEntityBotanyPot.tickPot(level, pos, state1, (TieredBlockEntityBotanyPot)pot));
    }
}

