/*
 * Decompiled with CFR 0.152.
 */
package capsule;

import capsule.CapsuleSavedData;
import capsule.Config;
import capsule.items.CapsuleItem;
import capsule.plugins.securitycraft.SecurityCraftOwnerCheck;
import capsule.structure.CapsuleTemplate;
import capsule.structure.CapsuleTemplateManager;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.StringUtil;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="capsule", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class StructureSaver {
    protected static final Logger LOGGER = LogManager.getLogger(StructureSaver.class);
    public static final String BLUEPRINT_PREFIX = "b-";
    public static Map<String, CapsuleTemplateManager> CapsulesManagers = new HashMap<String, CapsuleTemplateManager>();
    private static CapsuleTemplateManager RewardManager = null;
    private static final List<String> outExcluded = new ArrayList<String>();
    private static boolean preventItemDrop = false;

    public static CapsuleTemplateManager getRewardManager(ResourceManager resourceManager) {
        if (RewardManager == null) {
            File rewardDir = new File(Config.rewardTemplatesPath);
            if (!rewardDir.exists()) {
                rewardDir.mkdirs();
            }
            RewardManager = new CapsuleTemplateManager(resourceManager, new File("."), DataFixers.m_14512_());
        }
        return RewardManager;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleEntityJoinWorldEvent(EntityJoinLevelEvent e) {
        if (preventItemDrop && e.getEntity() instanceof ItemEntity) {
            e.setCanceled(true);
        }
    }

    public static CapsuleTemplate undeploy(ServerLevel worldserver, @Nullable UUID playerID, String capsuleStructureId, BlockPos startPos, int size, List<Block> excluded, Map<BlockPos, Block> legacyItemOccupied) {
        boolean writingOK;
        MinecraftServer minecraftserver = worldserver.m_7654_();
        if (minecraftserver == null) {
            LOGGER.error("worldserver.getServer() returned null");
            return null;
        }
        ArrayList<Entity> outCapturedEntities = new ArrayList<Entity>();
        CapsuleTemplateManager templatemanager = StructureSaver.getTemplateManager(worldserver.m_7654_());
        if (templatemanager == null) {
            LOGGER.error("getTemplateManager returned null");
            return null;
        }
        CapsuleTemplate template = templatemanager.getOrCreateTemplate(new ResourceLocation(capsuleStructureId));
        Map<BlockPos, Block> occupiedPositions = template.occupiedPositions;
        if (legacyItemOccupied != null) {
            occupiedPositions = legacyItemOccupied;
        }
        List<BlockPos> transferedPositions = template.snapshotBlocksFromWorld((Level)worldserver, startPos, new BlockPos(size, size, size), occupiedPositions, excluded, outCapturedEntities);
        template.removeOccupiedPositions();
        Player player = null;
        if (playerID != null && (player = worldserver.m_46003_(playerID)) != null) {
            template.setAuthor(player.m_36316_().getName());
        }
        if (writingOK = templatemanager.writeToFile(new ResourceLocation(capsuleStructureId))) {
            List<BlockPos> couldNotBeRemoved = StructureSaver.removeTransferedBlockFromWorld(transferedPositions, worldserver, player);
            for (Entity e : outCapturedEntities) {
                if (e instanceof AbstractMinecartContainer) {
                    AbstractMinecartContainer eMinecart = (AbstractMinecartContainer)e;
                    eMinecart.m_6211_();
                }
                e.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            if (couldNotBeRemoved != null) {
                template.removeBlocks(couldNotBeRemoved, startPos);
            }
            templatemanager.writeToFile(new ResourceLocation(capsuleStructureId));
        } else {
            StructureSaver.printWriteTemplateError(player, capsuleStructureId);
        }
        return template;
    }

    public static boolean undeployBlueprint(ServerLevel worldserver, UUID playerID, ItemStack blueprintItemStack, BlockPos startPos, int size, List<Block> excluded) {
        Pair<CapsuleTemplateManager, CapsuleTemplate> blueprint = StructureSaver.getTemplate(blueprintItemStack, worldserver);
        CapsuleTemplate blueprintTemplate = (CapsuleTemplate)blueprint.getRight();
        if (blueprintTemplate == null) {
            return false;
        }
        CapsuleTemplate tempTemplate = new CapsuleTemplate();
        Map<BlockPos, Block> occupiedPositions = blueprintTemplate.occupiedPositions;
        Map<BlockPos, Block> legacyItemOccupied = CapsuleItem.getOccupiedSourcePos(blueprintItemStack);
        if (legacyItemOccupied != null) {
            occupiedPositions = legacyItemOccupied;
        }
        List<BlockPos> transferedPositions = tempTemplate.snapshotBlocksFromWorld((Level)worldserver, startPos, new BlockPos(size, size, size), occupiedPositions, excluded, null);
        List worldBlocks = tempTemplate.getPalette().stream().filter(b -> !StructureSaver.isFlowingLiquid(b)).collect(Collectors.toList());
        List blueprintBLocks = blueprintTemplate.getPalette().stream().filter(b -> !StructureSaver.isFlowingLiquid(b)).collect(Collectors.toList());
        Player player = null;
        if (playerID != null) {
            player = worldserver.m_46003_(playerID);
        }
        if (blueprintBLocks.size() != worldBlocks.size()) {
            return false;
        }
        List tempTemplateSorted = worldBlocks.stream().map(StructureSaver::serializeComparable).sorted().collect(Collectors.toList());
        List blueprintTemplateSorted = blueprintBLocks.stream().map(StructureSaver::serializeComparable).sorted().collect(Collectors.toList());
        boolean blueprintMatch = IntStream.range(0, tempTemplateSorted.size()).allMatch(i -> ((String)tempTemplateSorted.get(i)).equals(blueprintTemplateSorted.get(i)));
        boolean bl = blueprintMatch = blueprintMatch && worldBlocks.stream().allMatch(b -> b.f_74677_ == null || !b.f_74677_.m_128441_("Items") || b.f_74677_.m_128437_("Items", 10).isEmpty());
        if (blueprintMatch) {
            blueprintTemplate.removeOccupiedPositions();
            String capsuleStructureId = CapsuleItem.getStructureName(blueprintItemStack);
            boolean written = ((CapsuleTemplateManager)blueprint.getLeft()).writeToFile(new ResourceLocation(capsuleStructureId));
            if (written) {
                List<BlockPos> couldNotBeRemoved = StructureSaver.removeTransferedBlockFromWorld(transferedPositions, worldserver, player);
                if (couldNotBeRemoved != null) {
                    return false;
                }
            } else {
                StructureSaver.printWriteTemplateError(player, capsuleStructureId);
            }
        }
        return blueprintMatch;
    }

    public static String serializeComparable(StructureTemplate.StructureBlockInfo b) {
        return b.f_74676_.m_60734_().m_7705_() + "@" + b.f_74676_.m_60734_().m_49966_() + (b.f_74677_ == null ? "" : StructureSaver.nbtStringNotEmpty(StructureSaver.filterIdentityNBT(b)));
    }

    public static CompoundTag filterIdentityNBT(StructureTemplate.StructureBlockInfo b) {
        CompoundTag nbt = b.f_74677_.m_6426_();
        List<String> converted = Config.getBlueprintIdentityNBT(b.f_74676_.m_60734_());
        nbt.m_128431_().removeIf(key -> converted == null || !converted.contains(key));
        return nbt;
    }

    public static String nbtStringNotEmpty(CompoundTag nbt) {
        if (nbt.m_128456_()) {
            return "";
        }
        return nbt.toString();
    }

    public static boolean isFlowingLiquid(StructureTemplate.StructureBlockInfo b) {
        return b.f_74676_.m_60734_() instanceof LiquidBlock && (Integer)b.f_74676_.m_61143_((Property)LiquidBlock.f_54688_) != 0;
    }

    @Nullable
    public static CapsuleTemplateManager getTemplateManager(MinecraftServer server) {
        LevelResource folder = new LevelResource("capsules");
        Path directoryPath = server.m_129843_(folder);
        if (!CapsulesManagers.containsKey(directoryPath.toString())) {
            File capsuleDir = directoryPath.toFile();
            capsuleDir.mkdirs();
            CapsulesManagers.put(directoryPath.toString(), new CapsuleTemplateManager(server.m_177941_(), capsuleDir, DataFixers.m_14512_()));
        }
        return CapsulesManagers.get(directoryPath.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BlockPos> removeTransferedBlockFromWorld(List<BlockPos> transferedPositions, ServerLevel world, @Nullable Player player) {
        ArrayList<BlockPos> couldNotBeRemoved = null;
        GameRules.BooleanValue entityDropsGameRule = (GameRules.BooleanValue)world.m_46469_().m_46170_(GameRules.f_46137_);
        GameRules.BooleanValue tileDropsGameRule = (GameRules.BooleanValue)world.m_46469_().m_46170_(GameRules.f_46136_);
        boolean flagdoEntityDrops = world.m_46469_().m_46207_(GameRules.f_46137_);
        boolean flagdoTileDrops = world.m_46469_().m_46207_(GameRules.f_46136_);
        entityDropsGameRule.m_46246_(false, world.m_7654_());
        tileDropsGameRule.m_46246_(false, world.m_7654_());
        world.restoringBlockSnapshots = true;
        preventItemDrop = true;
        try {
            for (BlockPos pos : transferedPositions) {
                BlockState b = world.m_8055_(pos);
                try {
                    if (StructureSaver.playerCanRemove(world, pos, player)) {
                        BlockEntity BlockEntity2;
                        BlockEntity blockEntity = BlockEntity2 = b.m_155947_() ? world.m_7702_(pos) : null;
                        if (BlockEntity2 != null) {
                            Clearable.m_18908_((Object)BlockEntity2);
                            world.m_7731_(pos, Blocks.f_50375_.m_49966_(), 20);
                        }
                        world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
                        continue;
                    }
                    if (couldNotBeRemoved == null) {
                        couldNotBeRemoved = new ArrayList<BlockPos>();
                    }
                    couldNotBeRemoved.add(pos);
                }
                catch (Exception e) {
                    StructureSaver.printDeployError(player, e, "Block crashed during Capsule capture phase : couldn't be removed. Will be ignored.");
                    try {
                        world.m_7731_(pos, b, 3);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (couldNotBeRemoved == null) {
                        couldNotBeRemoved = new ArrayList();
                    }
                    couldNotBeRemoved.add(pos);
                }
            }
        }
        finally {
            preventItemDrop = false;
            world.restoringBlockSnapshots = false;
            entityDropsGameRule.m_46246_(flagdoEntityDrops, world.m_7654_());
            tileDropsGameRule.m_46246_(flagdoTileDrops, world.m_7654_());
        }
        return couldNotBeRemoved;
    }

    public static boolean deploy(ItemStack capsule, ServerLevel playerWorld, @Nullable UUID thrower, BlockPos dest, List<Block> overridableBlocks, StructurePlaceSettings placementsettings) {
        Pair<CapsuleTemplateManager, CapsuleTemplate> templatepair = StructureSaver.getTemplate(capsule, playerWorld);
        CapsuleTemplate template = (CapsuleTemplate)templatepair.getRight();
        if (template == null) {
            return false;
        }
        ServerPlayer player = null;
        if (thrower != null) {
            player = playerWorld.m_7654_().m_6846_().m_11259_(thrower);
        }
        HashMap<BlockPos, Block> outOccupiedSpawnPositions = new HashMap<BlockPos, Block>();
        int size = CapsuleItem.getSize(capsule);
        ArrayList<Component> outErrors = new ArrayList<Component>();
        StructureSaver.checkDestination(template, placementsettings, playerWorld, dest, size, overridableBlocks, outOccupiedSpawnPositions, outErrors);
        if (outErrors.size() > 0) {
            if (player != null) {
                StructureSaver.printDeployFailure((Player)player, outErrors);
            }
            return false;
        }
        if (player != null && !StructureSaver.playerCanPlace(playerWorld, dest, template, (Player)player, placementsettings)) {
            player.m_213846_((Component)Component.m_237115_((String)"capsule.error.notAllowed"));
            return false;
        }
        HashMap<BlockPos, Block> occupiedPositions = outOccupiedSpawnPositions;
        ArrayList<BlockPos> spawnedBlocks = new ArrayList<BlockPos>();
        ArrayList<Entity> spawnedEntities = new ArrayList<Entity>();
        CapsuleTemplateManager templateManager = (CapsuleTemplateManager)templatepair.getLeft();
        String capsuleStructureId = CapsuleItem.getStructureName(capsule);
        template.saveOccupiedPositions(occupiedPositions);
        if (!templateManager.writeToFile(new ResourceLocation(capsuleStructureId))) {
            StructureSaver.printWriteTemplateError((Player)player, capsuleStructureId);
            return false;
        }
        try {
            template.spawnBlocksAndEntities((ServerLevelAccessor)playerWorld, dest, placementsettings, occupiedPositions, overridableBlocks, spawnedBlocks, spawnedEntities);
            StructureSaver.placePlayerOnTop(playerWorld, dest, size);
            return true;
        }
        catch (Exception err) {
            StructureSaver.printDeployError((Player)player, err, "Couldn't deploy the capsule");
            StructureSaver.removeTransferedBlockFromWorld(spawnedBlocks, playerWorld, (Player)player);
            template.removeOccupiedPositions();
            if (!templateManager.writeToFile(new ResourceLocation(capsuleStructureId))) {
                StructureSaver.printWriteTemplateError((Player)player, capsuleStructureId);
            }
            for (Entity e : spawnedEntities) {
                if (e instanceof AbstractMinecartContainer) {
                    AbstractMinecartContainer eMinecart = (AbstractMinecartContainer)e;
                    eMinecart.m_6211_();
                }
                e.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return false;
        }
    }

    private static void printDeployFailure(Player player, List<Component> outErrors) {
        MutableComponent msg = Component.m_237113_((String)"");
        int outErrorsSize = outErrors.size();
        for (int i = 0; i < outErrorsSize; ++i) {
            Component outError = outErrors.get(i);
            msg.m_7220_(outError);
            if (i >= outErrors.size() - 1) continue;
            msg.m_130946_("\n");
        }
        player.m_213846_((Component)msg);
    }

    public static void placePlayerOnTop(ServerLevel playerWorld, BlockPos dest, int size) {
        List players = playerWorld.m_6443_(LivingEntity.class, new AABB((double)dest.m_123341_(), (double)dest.m_123342_(), (double)dest.m_123343_(), (double)(dest.m_123341_() + size), (double)(dest.m_123342_() + size), (double)(dest.m_123343_() + size)), entity -> entity instanceof Player);
        for (LivingEntity p : players) {
            for (int y = 0; y < size; ++y) {
                if (StructureSaver.checkBlockCollision((Entity)p)) continue;
                p.m_6027_(p.m_20185_(), p.m_20186_() + 1.0, p.m_20189_());
            }
        }
    }

    private static boolean checkBlockCollision(Entity entity) {
        return BlockPos.m_121921_((AABB)entity.m_20191_()).allMatch(p -> {
            BlockState state = entity.f_19853_.m_8055_(p);
            return state.m_60795_();
        });
    }

    public static void printDeployError(@Nullable Player player, Exception err, String s) {
        LOGGER.error(s, (Throwable)err);
        if (player != null) {
            player.m_213846_((Component)Component.m_237115_((String)"capsule.error.technicalError"));
        }
    }

    public static void printWriteTemplateError(@Nullable Player player, String capsuleStructureId) {
        LOGGER.error("Couldn't write template " + capsuleStructureId);
        if (player != null) {
            player.m_213846_((Component)Component.m_237115_((String)"capsule.error.technicalError"));
        }
    }

    private static boolean playerCanPlace(ServerLevel worldserver, BlockPos dest, CapsuleTemplate template, Player player, StructurePlaceSettings placementsettings) {
        if (player != null) {
            List<BlockPos> expectedOut = template.calculateDeployPositions((Level)worldserver, dest, placementsettings);
            for (BlockPos blockPos : expectedOut) {
                if (blockPos.m_123342_() < worldserver.m_151558_() && blockPos.m_123342_() > worldserver.m_141937_() && StructureSaver.isEntityPlaceEventAllowed(worldserver, blockPos, player)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean playerCanRemove(ServerLevel worldserver, BlockPos blockPos, @Nullable Player player) {
        if (player != null) {
            return StructureSaver.isEntityPlaceEventAllowed(worldserver, blockPos, player) && SecurityCraftOwnerCheck.canTakeBlock(worldserver, blockPos, player);
        }
        return true;
    }

    private static boolean isEntityPlaceEventAllowed(ServerLevel worldserver, BlockPos blockPos, @Nullable Player player) {
        BlockSnapshot blocksnapshot = BlockSnapshot.create((ResourceKey)worldserver.m_46472_(), (LevelAccessor)worldserver, (BlockPos)blockPos);
        BlockEvent.EntityPlaceEvent event = new BlockEvent.EntityPlaceEvent(blocksnapshot, Blocks.f_50493_.m_49966_(), (Entity)player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    public static Pair<CapsuleTemplateManager, CapsuleTemplate> getTemplate(ItemStack capsule, ServerLevel playerWorld) {
        Pair<CapsuleTemplateManager, CapsuleTemplate> template = null;
        boolean isReward = CapsuleItem.isReward(capsule);
        String structureName = CapsuleItem.getStructureName(capsule);
        template = isReward || structureName.startsWith("config/") && CapsuleItem.isBlueprint(capsule) ? StructureSaver.getTemplateForReward(playerWorld.m_7654_(), structureName) : StructureSaver.getTemplateForCapsule(playerWorld, structureName);
        return template;
    }

    public static Pair<CapsuleTemplateManager, CapsuleTemplate> getTemplateForCapsule(ServerLevel playerWorld, String structurePath) {
        CapsuleTemplateManager templatemanager = StructureSaver.getTemplateManager(playerWorld.m_7654_());
        if (templatemanager == null || StringUtil.m_14408_((String)structurePath)) {
            return Pair.of(null, null);
        }
        String path = structurePath.toLowerCase();
        CapsuleTemplate template = templatemanager.getOrCreateTemplate(new ResourceLocation(path));
        return Pair.of((Object)templatemanager, (Object)template);
    }

    public static Pair<CapsuleTemplateManager, CapsuleTemplate> getTemplateForReward(MinecraftServer server, String structurePath) {
        CapsuleTemplateManager templatemanager = StructureSaver.getRewardManager(server.m_177941_());
        if (templatemanager == null || StringUtil.m_14408_((String)structurePath)) {
            return Pair.of(null, null);
        }
        String path = structurePath.toLowerCase();
        CapsuleTemplate template = templatemanager.getOrCreateTemplate(new ResourceLocation(path));
        return Pair.of((Object)templatemanager, (Object)template);
    }

    public static void checkDestination(CapsuleTemplate template, StructurePlaceSettings placementIn, ServerLevel destWorld, BlockPos destOriginPos, int size, List<Block> overridable, Map<BlockPos, Block> outOccupiedPositions, List<Component> outErrors) {
        BlockState air = Blocks.f_50016_.m_49966_();
        List<StructureTemplate.StructureBlockInfo> srcblocks = template.getPalette();
        HashMap<BlockPos, StructureTemplate.StructureBlockInfo> blockInfoByPosition = new HashMap<BlockPos, StructureTemplate.StructureBlockInfo>();
        for (StructureTemplate.StructureBlockInfo template$blockinfo : srcblocks) {
            BlockPos blockpos = CapsuleTemplate.calculateRelativePosition(placementIn, template$blockinfo.f_74675_).m_121955_((Vec3i)destOriginPos).m_121955_((Vec3i)CapsuleTemplate.recenterRotation((size - 1) / 2, placementIn));
            blockInfoByPosition.put(blockpos, template$blockinfo);
        }
        for (int y = size - 1; y >= 0; --y) {
            for (int x = 0; x < size; ++x) {
                for (int z = 0; z < size; ++z) {
                    boolean worldDestOccupied;
                    BlockPos destPos = destOriginPos.m_7918_(x, y, z);
                    StructureTemplate.StructureBlockInfo srcInfo = (StructureTemplate.StructureBlockInfo)blockInfoByPosition.get(destPos);
                    BlockState templateBlockState = air;
                    if (srcInfo != null) {
                        templateBlockState = srcInfo.f_74676_;
                    }
                    if (!destWorld.m_46805_(destPos)) {
                        outErrors.add((Component)Component.m_237115_((String)"capsule.error.areaNotLoaded"));
                        return;
                    }
                    BlockState worldDestState = destWorld.m_8055_(destPos);
                    boolean bl = worldDestOccupied = !worldDestState.m_60795_() && !overridable.contains(worldDestState.m_60734_());
                    if (!worldDestState.m_60795_() && outOccupiedPositions != null) {
                        outOccupiedPositions.put(destPos, worldDestState.m_60734_());
                    }
                    boolean srcOccupied = !templateBlockState.m_60795_() && !overridable.contains(templateBlockState.m_60734_());
                    List entities = destWorld.m_6443_(LivingEntity.class, new AABB((double)destPos.m_123341_(), (double)destPos.m_123342_(), (double)destPos.m_123343_(), (double)(destPos.m_123341_() + 1), (double)(destPos.m_123342_() + 1), (double)(destPos.m_123343_() + 1)), entity -> !(entity instanceof Player));
                    if (entities.size() > 0 && srcOccupied) {
                        boolean found = false;
                        for (Object e : entities) {
                            Entity entity2 = (Entity)e;
                            if (entity2 == null) continue;
                            outErrors.add((Component)Component.m_237110_((String)"capsule.error.cantMergeWithDestinationEntity", (Object[])new Object[]{entity2.m_5446_()}));
                            found = true;
                        }
                        if (!found) {
                            outErrors.add((Component)Component.m_237110_((String)"capsule.error.cantMergeWithDestinationEntity", (Object[])new Object[]{"???"}));
                        }
                        return;
                    }
                    if (!worldDestOccupied || overridable.contains(templateBlockState.m_60734_())) continue;
                    outErrors.add((Component)Component.m_237110_((String)"capsule.error.cantMergeWithDestination", (Object[])new Object[]{destPos.toString()}));
                    return;
                }
            }
        }
    }

    public static String getUniqueName(ServerLevel playerWorld, String player) {
        CapsuleSavedData csd = StructureSaver.getCapsuleSavedData(playerWorld.m_7654_().m_129783_());
        String p = player.toLowerCase().codePoints().filter(c -> ResourceLocation.m_135816_((char)((char)c))).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
        String capsuleID = "c-" + p + "-" + csd.getNextCount();
        CapsuleTemplateManager templatemanager = StructureSaver.getTemplateManager(playerWorld.m_7654_().m_129783_().m_7654_());
        if (templatemanager == null) {
            LOGGER.error("getTemplateManager returned null");
            return "cexception-" + p + "-" + csd.getNextCount();
        }
        while (templatemanager.getTemplate(new ResourceLocation(capsuleID)) != null) {
            capsuleID = "c-" + p + "-" + csd.getNextCount();
        }
        return capsuleID;
    }

    public static String getBlueprintUniqueName(ServerLevel world) {
        CapsuleSavedData csd = StructureSaver.getCapsuleSavedData(world);
        String capsuleID = BLUEPRINT_PREFIX + csd.getNextCount();
        CapsuleTemplateManager templatemanager = StructureSaver.getTemplateManager(world.m_7654_());
        if (templatemanager == null) {
            LOGGER.error("getTemplateManager returned null");
            return "bexception-" + csd.getNextCount();
        }
        while (templatemanager.getTemplate(new ResourceLocation(capsuleID)) != null) {
            capsuleID = BLUEPRINT_PREFIX + csd.getNextCount();
        }
        return capsuleID;
    }

    public static boolean copyFromCapsuleTemplate(ItemStack capsule, String destinationStructureName, CapsuleTemplateManager destManager, ServerLevel worldServer, boolean onlyBlocks, List<String> outExcluded) {
        CompoundTag srcTemplateData = StructureSaver.getTemplateNBTData(capsule, worldServer);
        if (srcTemplateData == null) {
            return false;
        }
        return StructureSaver.duplicateTemplate(srcTemplateData, destinationStructureName, destManager, onlyBlocks, outExcluded);
    }

    public static boolean duplicateTemplate(CompoundTag templateData, String destinationStructureName, CapsuleTemplateManager destManager, MinecraftServer server) {
        return StructureSaver.duplicateTemplate(templateData, destinationStructureName, destManager, false, null);
    }

    public static boolean duplicateTemplate(CompoundTag templateData, String destinationStructureName, CapsuleTemplateManager destManager, boolean onlyWhitelisted, List<String> outExcluded) {
        String sanitized = destinationStructureName.toLowerCase();
        ResourceLocation destinationLocation = new ResourceLocation(sanitized);
        CapsuleTemplate destTemplate = destManager.getOrCreateTemplate(destinationLocation);
        destTemplate.load(templateData, destinationLocation.toString());
        destTemplate.occupiedPositions = null;
        if (onlyWhitelisted) {
            destTemplate.filterFromWhitelist(outExcluded);
        }
        return destManager.writeToFile(destinationLocation);
    }

    public static CompoundTag getTemplateNBTData(ItemStack capsule, ServerLevel worldServer) {
        return StructureSaver.getTemplateNBTData((CapsuleTemplate)StructureSaver.getTemplate(capsule, worldServer).getRight());
    }

    public static CompoundTag getTemplateNBTData(String path, ServerLevel worldServer) {
        Pair<CapsuleTemplateManager, CapsuleTemplate> sourcetemplatepair = path.startsWith(Config.rewardTemplatesPath) || path.startsWith("config/") ? StructureSaver.getTemplateForReward(worldServer.m_7654_(), path) : StructureSaver.getTemplateForCapsule(worldServer, path);
        return StructureSaver.getTemplateNBTData((CapsuleTemplate)sourcetemplatepair.getRight());
    }

    public static CompoundTag getTemplateNBTData(CapsuleTemplate template) {
        if (template == null) {
            return null;
        }
        CompoundTag data = new CompoundTag();
        template.save(data);
        return data;
    }

    public static CapsuleSavedData getCapsuleSavedData(ServerLevel capsuleWorld) {
        return (CapsuleSavedData)capsuleWorld.m_8895_().m_164861_(CapsuleSavedData::load, CapsuleSavedData::new, "capsuleData");
    }

    @Nullable
    public static String createBlueprintTemplate(String srcStructurePath, ItemStack destCapsule, ServerLevel worldServer, Player playerIn) {
        boolean created;
        if (worldServer == null) {
            LOGGER.error("worldServer is null");
            return null;
        }
        String destStructureName = StructureSaver.getBlueprintUniqueName(worldServer) + "-" + srcStructurePath.replace("/", "_");
        CapsuleTemplateManager templateManager = StructureSaver.getTemplateManager(worldServer.m_7654_());
        outExcluded.clear();
        boolean bl = created = templateManager != null && StructureSaver.duplicateTemplate(StructureSaver.getTemplateNBTData(srcStructurePath, worldServer), destStructureName, templateManager, true, outExcluded);
        if (destCapsule.m_41783_() != null && destCapsule.m_41783_().m_128441_("prevStructureName") && templateManager != null) {
            try {
                templateManager.deleteTemplate(new ResourceLocation(destCapsule.m_41783_().m_128461_("prevStructureName")));
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
        }
        if (!created && playerIn != null) {
            playerIn.m_213846_((Component)Component.m_237115_((String)"capsule.error.blueprintCreationError"));
        }
        if (outExcluded.size() > 0 && playerIn != null) {
            playerIn.m_213846_((Component)Component.m_237110_((String)"capsule.error.blueprintExcluded", (Object[])new Object[]{"\n* " + String.join((CharSequence)"\n* ", outExcluded)}));
        }
        return destStructureName;
    }

    public static class ItemStackKey
    implements Comparable<ItemStackKey> {
        public ItemStack itemStack;

        public ItemStackKey(ItemStack itemStack) {
            this.itemStack = itemStack;
        }

        public boolean equals(Object someOther) {
            if (!(someOther instanceof ItemStackKey)) {
                return false;
            }
            ItemStack otherStack = ((ItemStackKey)someOther).itemStack;
            return otherStack.m_41656_(this.itemStack) && (!otherStack.m_41782_() && !this.itemStack.m_41782_() || otherStack.m_41783_().equals((Object)this.itemStack.m_41783_()));
        }

        public int hashCode() {
            int val = this.itemStack.m_41720_().hashCode() * 29 + CapsuleItem.getState(this.itemStack).getValue();
            return val;
        }

        @Override
        public int compareTo(ItemStackKey o) {
            if (o == null || o.itemStack == null) {
                return 1;
            }
            return this.equals(o) ? 0 : ItemStackKey.serializeItemStack(this.itemStack).compareTo(ItemStackKey.serializeItemStack(o.itemStack));
        }

        public static String serializeItemStack(ItemStack itemstack) {
            return itemstack.m_41720_().m_5524_() + "@" + CapsuleItem.getState(itemstack);
        }
    }
}

