/*
 * Decompiled with CFR 0.152.
 */
package capsule.items;

import capsule.items.CapsuleItem;
import capsule.recipes.BlueprintCapsuleRecipe;
import capsule.recipes.BlueprintChangeRecipe;
import capsule.recipes.PrefabsBlueprintAggregatorRecipe;
import capsule.recipes.RecoveryCapsuleRecipe;
import capsule.recipes.UpgradeCapsuleRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;

public class CapsuleItems {
    private static final int UPGRADE_STEP = 2;
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"capsule");
    public static final RegistryObject<CapsuleItem> CAPSULE = ITEMS.register("capsule", CapsuleItem::new);
    public static TreeMap<ItemStack, CraftingRecipe> capsuleList = new TreeMap(Comparator.comparingDouble(CapsuleItems::compare));
    public static TreeMap<ItemStack, CraftingRecipe> opCapsuleList = new TreeMap(Comparator.comparingDouble(CapsuleItems::compare));
    public static List<Pair<ItemStack, CraftingRecipe>> blueprintCapsules = new ArrayList<Pair<ItemStack, CraftingRecipe>>();
    public static List<Pair<ItemStack, CraftingRecipe>> blueprintPrefabs = new ArrayList<Pair<ItemStack, CraftingRecipe>>();
    public static Pair<ItemStack, CraftingRecipe> unlabelledCapsule = null;
    public static Pair<ItemStack, CraftingRecipe> deployedCapsule = null;
    public static Pair<ItemStack, RecoveryCapsuleRecipe> recoveryCapsule = null;
    public static Pair<ItemStack, BlueprintChangeRecipe> blueprintChangedCapsule = null;
    public static Pair<ItemStack, UpgradeCapsuleRecipe> upgradedCapsule = null;

    public static ItemStack withState(CapsuleItem.CapsuleState state) {
        ItemStack capsule = new ItemStack((ItemLike)CAPSULE.get(), 1);
        CapsuleItem.setState(capsule, state);
        return capsule;
    }

    private static double compare(ItemStack capsule) {
        return (double)CapsuleItem.getSize(capsule) + (double)CapsuleItem.getMaterialColor(capsule) * 1.0E-12;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRecipesClient(RecipeManager manager) {
        blueprintCapsules.clear();
        blueprintPrefabs.clear();
        capsuleList.clear();
        opCapsuleList.clear();
        unlabelledCapsule = null;
        deployedCapsule = null;
        recoveryCapsule = null;
        blueprintChangedCapsule = null;
        upgradedCapsule = null;
        for (Recipe recipe : manager.m_44051_()) {
            if (!recipe.m_6423_().m_135827_().equals("capsule") || !CapsuleItems.hasNoEmptyTagsIngredient(recipe)) continue;
            if (recipe instanceof BlueprintCapsuleRecipe) {
                blueprintCapsules.add((Pair<ItemStack, CraftingRecipe>)Pair.of((Object)((BlueprintCapsuleRecipe)recipe).m_8043_(), (Object)((BlueprintCapsuleRecipe)recipe).recipe));
                continue;
            }
            if (recipe instanceof RecoveryCapsuleRecipe) {
                recoveryCapsule = Pair.of((Object)((RecoveryCapsuleRecipe)recipe).m_8043_(), (Object)((RecoveryCapsuleRecipe)recipe));
                continue;
            }
            if (recipe instanceof UpgradeCapsuleRecipe) {
                upgradedCapsule = Pair.of((Object)recipe.m_8043_(), (Object)((UpgradeCapsuleRecipe)recipe));
                continue;
            }
            if (recipe instanceof BlueprintChangeRecipe) {
                blueprintChangedCapsule = Pair.of((Object)recipe.m_8043_(), (Object)((Object)((BlueprintChangeRecipe)recipe)));
                continue;
            }
            if (recipe instanceof PrefabsBlueprintAggregatorRecipe) {
                PrefabsBlueprintAggregatorRecipe agg = (PrefabsBlueprintAggregatorRecipe)recipe;
                for (PrefabsBlueprintAggregatorRecipe.PrefabsBlueprintCapsuleRecipe aggregatorRecipe : agg.recipes) {
                    blueprintPrefabs.add((Pair<ItemStack, CraftingRecipe>)Pair.of((Object)aggregatorRecipe.m_8043_(), (Object)aggregatorRecipe.recipe));
                }
                continue;
            }
            ItemStack output = recipe.m_8043_();
            if (!(output.m_41720_() instanceof CapsuleItem) || !(recipe instanceof ShapedRecipe)) continue;
            if (CapsuleItem.isOverpowered(output)) {
                opCapsuleList.put(output, (CraftingRecipe)((ShapedRecipe)recipe));
                continue;
            }
            capsuleList.put(output, (CraftingRecipe)((ShapedRecipe)recipe));
        }
        if (capsuleList.size() > 0) {
            unlabelledCapsule = Pair.of((Object)CapsuleItems.getUnlabelledCapsule(capsuleList.firstKey()), null);
            deployedCapsule = Pair.of((Object)CapsuleItems.getDeployedCapsule(capsuleList.firstKey()), null);
        }
    }

    private static boolean hasNoEmptyTagsIngredient(Recipe<?> recipe) {
        return recipe.m_7527_().stream().allMatch(i -> i.m_43947_() || Arrays.stream(i.m_43908_()).noneMatch(s -> s.m_41720_() == Items.f_42127_));
    }

    public static ItemStack getUnlabelledCapsule(ItemStack capsule) {
        ItemStack unlabelledCapsule = capsule.m_41777_();
        CapsuleItem.setState(unlabelledCapsule, CapsuleItem.CapsuleState.LINKED);
        CapsuleItem.setStructureName(unlabelledCapsule, "config/capsule/rewards/example");
        return unlabelledCapsule;
    }

    public static ItemStack getDeployedCapsule(ItemStack capsule) {
        ItemStack unlabelledCapsule = capsule.m_41777_();
        CapsuleItem.setState(unlabelledCapsule, CapsuleItem.CapsuleState.DEPLOYED);
        CapsuleItem.setStructureName(unlabelledCapsule, "config/capsule/rewards/example");
        return unlabelledCapsule;
    }

    public static ItemStack getUpgradedCapsule(ItemStack ironCapsule, int upLevel) {
        ItemStack capsuleUp = ironCapsule.m_41777_();
        CapsuleItem.setSize(capsuleUp, CapsuleItem.getSize(ironCapsule) + upLevel * 2);
        CapsuleItem.setUpgradeLevel(capsuleUp, upLevel);
        capsuleUp.m_41700_("upgraded", (Tag)IntTag.m_128679_((int)upLevel));
        return capsuleUp;
    }

    public static void registerItems(IEventBus modEventBus) {
        ITEMS.register(modEventBus);
    }
}

