/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.block;

import com.cyanogen.experienceobelisk.block.ExperienceReceivingBlock;
import com.cyanogen.experienceobelisk.block_entities.ExperienceFountainEntity;
import com.cyanogen.experienceobelisk.block_entities.ExperienceObeliskEntity;
import com.cyanogen.experienceobelisk.registries.RegisterBlockEntities;
import com.cyanogen.experienceobelisk.registries.RegisterFluids;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class ExperienceFountainBlock
extends ExperienceReceivingBlock
implements EntityBlock {
    VoxelShape center = Shapes.m_83064_((AABB)new AABB(0.28125, 0.0, 0.28125, 0.71875, 0.53125, 0.71875));
    VoxelShape shape1 = Shapes.m_83064_((AABB)new AABB(0.125, 0.08125, 0.2875, 0.875, 0.14375, 0.7125));
    VoxelShape shape2 = Shapes.m_83064_((AABB)new AABB(0.2875, 0.08125, 0.125, 0.7125, 0.14375, 0.875));

    public ExperienceFountainBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(9.0f).m_155954_(1.2f).m_60999_().m_155956_(9.0f).m_60955_().m_60953_(pLightEmission -> 7));
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (super.m_6227_(state, level, pos, player, hand, hit) != InteractionResult.PASS) {
            return InteractionResult.CONSUME;
        }
        BlockEntity entity = level.m_7702_(pos);
        ItemStack heldItem = player.m_21120_(hand);
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)heldItem, (int)1)).orElse(null);
        if (entity instanceof ExperienceFountainEntity) {
            BlockEntity blockEntity;
            ExperienceFountainEntity fountain = (ExperienceFountainEntity)entity;
            if (fountain.isBound && (blockEntity = level.m_7702_(fountain.getBoundPos())) instanceof ExperienceObeliskEntity) {
                ExperienceObeliskEntity obelisk = (ExperienceObeliskEntity)blockEntity;
                if (heldItem.m_41720_() == Items.f_42612_ || heldItem.m_41720_() == Items.f_42590_) {
                    this.handleExperienceBottle(heldItem, player, hand, obelisk);
                    return InteractionResult.m_19078_((boolean)true);
                }
                if (fluidHandler != null) {
                    this.handleExperienceItem(heldItem, fluidHandler, player, hand, obelisk);
                    return InteractionResult.m_19078_((boolean)true);
                }
            }
            fountain.cycleActivityState();
            MutableComponent message = Component.m_237119_();
            switch (fountain.getActivityState()) {
                case 0: {
                    message = Component.m_237115_((String)"message.experienceobelisk.experience_fountain.slow");
                    break;
                }
                case 1: {
                    message = Component.m_237115_((String)"message.experienceobelisk.experience_fountain.moderate");
                    break;
                }
                case 2: {
                    message = Component.m_237115_((String)"message.experienceobelisk.experience_fountain.fast");
                    break;
                }
                case 3: {
                    message = Component.m_237115_((String)"message.experienceobelisk.experience_fountain.hyper");
                }
            }
            player.m_5661_((Component)message, true);
            level.m_7260_(pos, state, state, 2);
        }
        if (!level.f_46443_) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public void handleExperienceItem(ItemStack heldItem, IFluidHandlerItem fluidHandler, Player player, InteractionHand hand, ExperienceObeliskEntity obelisk) {
        FluidStack cognitium = new FluidStack((Fluid)RegisterFluids.COGNITIUM.get(), 1000);
        if (obelisk.getFluidAmount() >= 1000 && fluidHandler.fill(cognitium, IFluidHandler.FluidAction.SIMULATE) >= 1000) {
            if (!player.m_7500_()) {
                heldItem.m_41774_(1);
                fluidHandler.fill(cognitium, IFluidHandler.FluidAction.EXECUTE);
                ItemStack fluidItem = fluidHandler.getContainer();
                if (heldItem.m_41619_()) {
                    player.m_21008_(hand, fluidItem);
                } else if (!player.m_36356_(fluidItem)) {
                    player.m_36176_(fluidItem, false);
                }
            }
            obelisk.drain(1000);
            player.m_5496_(SoundEvents.f_11781_, 1.0f, 1.0f);
        } else if (obelisk.getSpace() >= 1000 && fluidHandler.drain(cognitium, IFluidHandler.FluidAction.SIMULATE).getAmount() >= 1000) {
            if (!player.m_7500_()) {
                heldItem.m_41774_(1);
                fluidHandler.drain(cognitium, IFluidHandler.FluidAction.EXECUTE);
                ItemStack fluidItem = fluidHandler.getContainer();
                if (heldItem.m_41619_()) {
                    player.m_21008_(hand, fluidItem);
                } else if (!player.m_36356_(fluidItem)) {
                    player.m_36176_(fluidItem, false);
                }
            }
            obelisk.fill(1000);
            player.m_5496_(SoundEvents.f_11778_, 1.0f, 1.0f);
        }
    }

    public void handleExperienceBottle(ItemStack heldItem, Player player, InteractionHand hand, ExperienceObeliskEntity obelisk) {
        ItemStack experienceBottle = new ItemStack((ItemLike)Items.f_42612_, 1);
        ItemStack glassBottle = new ItemStack((ItemLike)Items.f_42590_, 1);
        if (heldItem.m_150930_(Items.f_42590_) && obelisk.getFluidAmount() >= 140) {
            if (!player.m_7500_()) {
                heldItem.m_41774_(1);
                if (heldItem.m_41619_()) {
                    player.m_21008_(hand, experienceBottle);
                } else if (!player.m_36356_(experienceBottle)) {
                    player.m_36176_(experienceBottle, false);
                }
            }
            obelisk.drain(140);
            player.m_5496_(SoundEvents.f_11770_, 1.0f, 1.0f);
        } else if (heldItem.m_150930_(Items.f_42612_) && obelisk.getSpace() >= 140) {
            if (!player.m_7500_()) {
                heldItem.m_41774_(1);
                if (heldItem.m_41619_()) {
                    player.m_21008_(hand, glassBottle);
                } else if (!player.m_36356_(glassBottle)) {
                    player.m_36176_(glassBottle, false);
                }
            }
            obelisk.fill(140);
            player.m_5496_(SoundEvents.f_11769_, 1.0f, 1.0f);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83113_((VoxelShape)Shapes.m_83113_((VoxelShape)this.center, (VoxelShape)this.shape1, (BooleanOp)BooleanOp.f_82695_), (VoxelShape)this.shape2, (BooleanOp)BooleanOp.f_82695_).m_83296_();
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return blockEntityType == RegisterBlockEntities.EXPERIENCEFOUNTAIN_BE.get() ? ExperienceFountainEntity::tick : null;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)RegisterBlockEntities.EXPERIENCEFOUNTAIN_BE.get()).m_155264_(pos, state);
    }
}

