/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.ingredient;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientSerializer;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;

public interface IPrototypedIngredient<T, M>
extends Comparable<IPrototypedIngredient<?, ?>> {
    public IngredientComponent<T, M> getComponent();

    public T getPrototype();

    public M getCondition();

    public static <T, M> CompoundTag serialize(IPrototypedIngredient<T, M> prototypedIngredient) {
        CompoundTag tag = new CompoundTag();
        IngredientComponent<T, M> component = prototypedIngredient.getComponent();
        tag.m_128359_("ingredientComponent", component.getName().toString());
        IIngredientSerializer<T, M> serializer = component.getSerializer();
        tag.m_128365_("prototype", serializer.serializeInstance(prototypedIngredient.getPrototype()));
        tag.m_128365_("condition", serializer.serializeCondition(prototypedIngredient.getCondition()));
        return tag;
    }

    public static PrototypedIngredient deserialize(CompoundTag tag) throws IllegalArgumentException {
        if (!tag.m_128425_("ingredientComponent", 8)) {
            throw new IllegalArgumentException("Could not find a ingredientComponent entry in the given tag");
        }
        if (!tag.m_128441_("prototype")) {
            throw new IllegalArgumentException("Could not find a prototype entry in the given tag");
        }
        if (!tag.m_128441_("condition")) {
            throw new IllegalArgumentException("Could not find a condition entry in the given tag");
        }
        String componentName = tag.m_128461_("ingredientComponent");
        IngredientComponent component = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation(componentName));
        if (component == null) {
            throw new IllegalArgumentException("Could not find the ingredient component type " + componentName);
        }
        IIngredientSerializer serializer = component.getSerializer();
        Object prototype = serializer.deserializeInstance(tag.m_128423_("prototype"));
        Object condition = serializer.deserializeCondition(tag.m_128423_("condition"));
        return new PrototypedIngredient(component, prototype, condition);
    }
}

