/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.comparator.DoubleComparator;
import corgitaco.corgilib.serialization.codec.CodecUtil;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class ItemStackCheck {
    public static final Codec<ItemStackCheck> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CodecUtil.ITEM_CODEC.fieldOf("item").forGetter(itemStackCheck -> itemStackCheck.item), (App)DoubleComparator.CODEC.optionalFieldOf("durability_is").forGetter(itemStackCheck -> itemStackCheck.durabilityComparator), (App)DoubleComparator.CODEC.optionalFieldOf("stack_size_is").forGetter(itemStackCheck -> itemStackCheck.stackSizeComparator), (App)Codec.unboundedMap(CodecUtil.ENCHANTMENT_CODEC, DoubleComparator.CODEC).optionalFieldOf("enchantment_check").forGetter(itemStackCheck -> itemStackCheck.enchantmentLevelComparator)).apply((Applicative)builder, ItemStackCheck::new));
    private final Item item;
    private final Optional<DoubleComparator> durabilityComparator;
    private final Optional<DoubleComparator> stackSizeComparator;
    private final Optional<Map<Enchantment, DoubleComparator>> enchantmentLevelComparator;

    public ItemStackCheck(Item item, Optional<DoubleComparator> durabilityComparator, Optional<DoubleComparator> stackSizeComparator, Optional<Map<Enchantment, DoubleComparator>> enchantmentLevelComparator) {
        this.item = item;
        if (!(durabilityComparator.isPresent() || stackSizeComparator.isPresent() || enchantmentLevelComparator.isPresent())) {
            throw new IllegalArgumentException("We need at least one check in an Item Stack Check!");
        }
        this.durabilityComparator = durabilityComparator;
        this.stackSizeComparator = stackSizeComparator;
        this.enchantmentLevelComparator = enchantmentLevelComparator;
    }

    public boolean test(ItemStack itemStack) {
        if (this.item == itemStack.m_41720_()) {
            if (this.durabilityComparator.isPresent() && !this.durabilityComparator.get().check(itemStack.m_41773_())) {
                return false;
            }
            if (this.stackSizeComparator.isPresent() && !this.stackSizeComparator.get().check(itemStack.m_41613_())) {
                return false;
            }
            if (this.enchantmentLevelComparator.isPresent()) {
                Map<Enchantment, DoubleComparator> enchantmentComparator = this.enchantmentLevelComparator.get();
                for (Map.Entry enchantmentIntegerEntry : EnchantmentHelper.m_44831_((ItemStack)itemStack).entrySet()) {
                    DoubleComparator doubleComparator;
                    if (!enchantmentComparator.containsKey(enchantmentIntegerEntry.getKey()) || (doubleComparator = enchantmentComparator.get(enchantmentIntegerEntry.getKey())).check(((Integer)enchantmentIntegerEntry.getValue()).intValue())) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public Item getItem() {
        return this.item;
    }
}

