/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.type;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.world.item.crafting.Ingredient;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.ingredient.type.IIngredientList")
@Document(value="vanilla/api/ingredient/type/IIngredientList")
public class IIngredientList
implements IIngredient {
    private final IIngredient[] ingredients;

    @ZenCodeType.Constructor
    public IIngredientList(IIngredient[] ingredients) {
        this.ingredients = IIngredientList.flatten(ingredients);
    }

    private static IIngredient[] flatten(IIngredient[] ingredients) {
        if (ingredients.length < 2) {
            return ingredients;
        }
        IIngredient[] result = new IIngredient[ingredients.length];
        int actualLength = 0;
        for (IIngredient ingredient : ingredients) {
            if (ingredient instanceof IIngredientList) {
                IIngredientList list = (IIngredientList)ingredient;
                IIngredient[] within = list.ingredients;
                int length = actualLength + within.length;
                if (length == actualLength) continue;
                if (length > result.length) {
                    result = Arrays.copyOf(result, length);
                }
                System.arraycopy(within, 0, result, actualLength, within.length);
                actualLength = length;
                continue;
            }
            if (ingredient.isEmpty()) continue;
            result[actualLength++] = ingredient;
            if (actualLength != result.length) continue;
            result = Arrays.copyOf(result, actualLength * 3 / 2);
        }
        return Arrays.copyOf(result, actualLength);
    }

    @Override
    public boolean isEmpty() {
        return this.ingredients.length == 0 || IIngredient.super.isEmpty();
    }

    @Override
    public boolean matches(IItemStack stack, boolean ignoreDamage) {
        for (IIngredient item : this.ingredients) {
            if (!item.matches(stack, ignoreDamage)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IIngredientList or(IIngredient other) {
        IIngredient[] newArray = Arrays.copyOf(this.ingredients, this.ingredients.length + 1);
        newArray[this.ingredients.length] = other;
        return new IIngredientList(newArray);
    }

    @Override
    public Ingredient asVanillaIngredient() {
        return Services.REGISTRY.getIngredientList(Arrays.stream(this.ingredients).map(IIngredient::asVanillaIngredient).collect(Collectors.toList()));
    }

    @Override
    public String getCommandString() {
        return Arrays.stream(this.ingredients).map(IIngredient::getCommandString).collect(Collectors.joining(" | "));
    }

    @Override
    public IItemStack[] getItems() {
        ArrayList stacks = new ArrayList();
        Arrays.stream(this.ingredients).map(ing -> Arrays.asList(ing.getItems())).forEach(stacks::addAll);
        return stacks.toArray(new IItemStack[0]);
    }

    public IIngredient[] getIngredients() {
        return this.ingredients;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IIngredientList that = (IIngredientList)o;
        return Arrays.equals(this.ingredients, that.ingredients);
    }

    public int hashCode() {
        return Arrays.hashCode(this.ingredients);
    }

    public String toString() {
        return this.getCommandString();
    }
}

