/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.plugin.crafttweaker;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.util.ClassUtil;
import com.blamejared.crafttweaker.impl.plugin.crafttweaker.CraftTweakerModList;
import com.blamejared.crafttweaker.platform.Services;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Either;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;

final class ZenClassGatherer {
    private final Supplier<ZenCandidates> zenCandidates = Suppliers.memoize(() -> {
        CraftTweakerModList modList = new CraftTweakerModList();
        List<ZenClassData> classes = ClassUtil.findClassesWithAnnotation(ZenRegister.class, modList::add, this::checkModDependencies).filter(Objects::nonNull).flatMap(this::makeForClass).toList();
        return new ZenCandidates(classes, modList::printToLog);
    });

    ZenClassGatherer() {
    }

    void onCandidates(Consumer<ZenClassData> consumer) {
        this.zenCandidates.get().classCandidates().forEach(consumer);
    }

    void listProviders() {
        this.zenCandidates.get().modsProvidingLister().run();
    }

    private boolean checkModDependencies(Either<ZenRegister, Map<String, Object>> annotationData) {
        return ((List)annotationData.map(zenRegister -> List.of(zenRegister.modDeps()), map -> map.getOrDefault("modDeps", List.of()))).stream().allMatch(Services.PLATFORM::isModLoaded);
    }

    private Stream<ZenClassData> makeForClass(Class<?> clazz) {
        return Arrays.stream(clazz.getDeclaredAnnotation(ZenRegister.class).loaders()).map(it -> new ZenClassData(clazz, (String)it));
    }

    private record ZenCandidates(List<ZenClassData> classCandidates, Runnable modsProvidingLister) {
    }

    record ZenClassData(Class<?> clazz, String loader) {
    }
}

