/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.platform;

import com.blamejared.crafttweaker.CraftTweakerRegistries;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.command.argument.IItemStackArgument;
import com.blamejared.crafttweaker.api.command.argument.RecipeTypeArgument;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.condition.serializer.ConditionAnyDamagedSerializer;
import com.blamejared.crafttweaker.api.ingredient.condition.serializer.ConditionCustomSerializer;
import com.blamejared.crafttweaker.api.ingredient.condition.serializer.ConditionDamagedSerializer;
import com.blamejared.crafttweaker.api.ingredient.serializer.IngredientAnySerializer;
import com.blamejared.crafttweaker.api.ingredient.serializer.IngredientConditionedSerializer;
import com.blamejared.crafttweaker.api.ingredient.serializer.IngredientListSerializer;
import com.blamejared.crafttweaker.api.ingredient.serializer.IngredientPartialTagSerializer;
import com.blamejared.crafttweaker.api.ingredient.serializer.IngredientTransformedSerializer;
import com.blamejared.crafttweaker.api.ingredient.transform.serializer.TransformCustomSerializer;
import com.blamejared.crafttweaker.api.ingredient.transform.serializer.TransformDamageSerializer;
import com.blamejared.crafttweaker.api.ingredient.transform.serializer.TransformReplaceSerializer;
import com.blamejared.crafttweaker.api.ingredient.transform.serializer.TransformerReuseSerializer;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientConditioned;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientTransformed;
import com.blamejared.crafttweaker.api.ingredient.type.IngredientAny;
import com.blamejared.crafttweaker.api.ingredient.type.IngredientConditioned;
import com.blamejared.crafttweaker.api.ingredient.type.IngredientList;
import com.blamejared.crafttweaker.api.ingredient.type.IngredientPartialTag;
import com.blamejared.crafttweaker.api.ingredient.type.IngredientTransformed;
import com.blamejared.crafttweaker.api.recipe.serializer.CTShapedRecipeSerializer;
import com.blamejared.crafttweaker.api.recipe.serializer.CTShapelessRecipeSerializer;
import com.blamejared.crafttweaker.api.recipe.serializer.ICTShapedRecipeBaseSerializer;
import com.blamejared.crafttweaker.api.recipe.serializer.ICTShapelessRecipeBaseSerializer;
import com.blamejared.crafttweaker.impl.loot.LootTableIdRegexCondition;
import com.blamejared.crafttweaker.impl.script.ScriptRecipeType;
import com.blamejared.crafttweaker.impl.script.ScriptSerializer;
import com.blamejared.crafttweaker.platform.services.IRegistryHelper;
import java.util.List;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ForgeRegistryHelper
implements IRegistryHelper {
    @Override
    public void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(newRegistry -> {
            CraftTweakerRegistries.REGISTRY_TRANSFORMER_SERIALIZER = this.registerVanillaRegistry(CraftTweakerConstants.rl("transformer_serializer"));
            CraftTweakerRegistries.REGISTRY_CONDITIONER_SERIALIZER = this.registerVanillaRegistry(CraftTweakerConstants.rl("condition_serializer"));
            this.registerSerializer(CraftTweakerRegistries.REGISTRY_TRANSFORMER_SERIALIZER, TransformReplaceSerializer.INSTANCE);
            this.registerSerializer(CraftTweakerRegistries.REGISTRY_TRANSFORMER_SERIALIZER, TransformDamageSerializer.INSTANCE);
            this.registerSerializer(CraftTweakerRegistries.REGISTRY_TRANSFORMER_SERIALIZER, TransformCustomSerializer.INSTANCE);
            this.registerSerializer(CraftTweakerRegistries.REGISTRY_TRANSFORMER_SERIALIZER, TransformerReuseSerializer.INSTANCE);
            this.registerSerializer(CraftTweakerRegistries.REGISTRY_CONDITIONER_SERIALIZER, ConditionDamagedSerializer.INSTANCE);
            this.registerSerializer(CraftTweakerRegistries.REGISTRY_CONDITIONER_SERIALIZER, ConditionAnyDamagedSerializer.INSTANCE);
            this.registerSerializer(CraftTweakerRegistries.REGISTRY_CONDITIONER_SERIALIZER, ConditionCustomSerializer.INSTANCE);
        });
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> {
            if (Registry.f_122901_.equals((Object)event.getRegistryKey())) {
                Registry.m_122965_((Registry)Registry.f_122877_, (ResourceLocation)new ResourceLocation("crafttweaker", "loot_table_id_regex"), (Object)LootTableIdRegexCondition.LOOT_TABLE_ID_REGEX);
            } else if (Registry.f_122915_.equals((Object)event.getRegistryKey())) {
                event.register(Registry.f_122915_, helper -> {
                    helper.register(CraftTweakerConstants.rl("shapeless"), (Object)CTShapelessRecipeSerializer.INSTANCE);
                    helper.register(CraftTweakerConstants.rl("shaped"), (Object)CTShapedRecipeSerializer.INSTANCE);
                    helper.register(CraftTweakerConstants.rl("script"), (Object)ScriptSerializer.INSTANCE);
                });
            } else if (Registry.f_122914_.equals((Object)event.getRegistryKey())) {
                event.register(Registry.f_122914_, helper -> helper.register(ScriptRecipeType.INSTANCE.id(), (Object)ScriptRecipeType.INSTANCE));
            } else if (Registry.f_235724_.equals((Object)event.getRegistryKey())) {
                event.register(Registry.f_235724_, helper -> {
                    helper.register(RecipeTypeArgument.ID, (Object)ArgumentTypeInfos.registerByClass(RecipeTypeArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(RecipeTypeArgument::get)));
                    helper.register(IItemStackArgument.ID, (Object)ArgumentTypeInfos.registerByClass(IItemStackArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(IItemStackArgument::get)));
                });
            }
        });
        CraftingHelper.register((ResourceLocation)CraftTweakerConstants.rl("any"), (IIngredientSerializer)IngredientAnySerializer.INSTANCE);
        CraftingHelper.register((ResourceLocation)CraftTweakerConstants.rl("list"), (IIngredientSerializer)IngredientListSerializer.INSTANCE);
        CraftingHelper.register((ResourceLocation)CraftTweakerConstants.rl("transformed"), (IIngredientSerializer)IngredientTransformedSerializer.INSTANCE);
        CraftingHelper.register((ResourceLocation)CraftTweakerConstants.rl("conditioned"), (IIngredientSerializer)IngredientConditionedSerializer.INSTANCE);
        CraftingHelper.register((ResourceLocation)CraftTweakerConstants.rl("partial_tag"), (IIngredientSerializer)IngredientPartialTagSerializer.INSTANCE);
    }

    @Override
    public ICTShapedRecipeBaseSerializer getCTShapedRecipeSerializer() {
        return CTShapedRecipeSerializer.INSTANCE;
    }

    @Override
    public ICTShapelessRecipeBaseSerializer getCTShapelessRecipeSerializer() {
        return CTShapelessRecipeSerializer.INSTANCE;
    }

    @Override
    public Ingredient getIngredientAny() {
        return IngredientAny.INSTANCE;
    }

    @Override
    public Ingredient getIngredientList(List<Ingredient> children) {
        return new IngredientList(children);
    }

    @Override
    public <T extends IIngredient> Ingredient getIngredientConditioned(IIngredientConditioned<T> conditioned) {
        return new IngredientConditioned(conditioned);
    }

    @Override
    public <T extends IIngredient> Ingredient getIngredientTransformed(IIngredientTransformed<T> transformed) {
        return new IngredientTransformed(transformed);
    }

    @Override
    public Ingredient getIngredientPartialTag(ItemStack stack) {
        return new IngredientPartialTag(stack);
    }
}

