/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.csg;

import com.brandon3055.csg.lib.PlayerSlot;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.Closeable;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataManager {
    private static Logger LOGGER = LogManager.getLogger();
    private static Path configFile;
    public static Map<PlayerSlot, CompoundTag> spawnInventory;
    public static Map<String, Map<PlayerSlot, CompoundTag>> kits;
    public static List<String> wipeBlacklist;

    public static void initialize() {
        configFile = Paths.get("./config/brandon3055/CSG/Config.json", new String[0]);
        if (!configFile.toFile().getParentFile().exists()) {
            configFile.toFile().getParentFile().mkdirs();
        }
        try {
            DataManager.loadConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveConfig() throws IOException {
        if (spawnInventory == null) {
            LOGGER.error("Could not save config because inventory array was null!");
            return;
        }
        JsonObject obj = new JsonObject();
        JsonObject inv = new JsonObject();
        spawnInventory.forEach((playerSlot, stack) -> inv.addProperty(playerSlot.toString(), stack.toString()));
        obj.add("inventory", (JsonElement)inv);
        if (kits.size() > 0) {
            JsonObject kitsObj = new JsonObject();
            kits.forEach((name, kit) -> {
                JsonObject kitObj = new JsonObject();
                kit.forEach((playerSlot, stack) -> kitObj.addProperty(playerSlot.toString(), stack.toString()));
                kitsObj.add(name, (JsonElement)kitObj);
            });
            obj.add("kits", (JsonElement)kitsObj);
        }
        JsonArray blacklist = new JsonArray();
        wipeBlacklist.forEach(arg_0 -> ((JsonArray)blacklist).add(arg_0));
        obj.add("wipeBlacklist", (JsonElement)blacklist);
        JsonWriter writer = new JsonWriter((Writer)new FileWriter(configFile.toFile()));
        writer.setIndent("  ");
        Streams.write((JsonElement)obj, (JsonWriter)writer);
        writer.flush();
        IOUtils.closeQuietly((Closeable)writer);
    }

    public static void loadConfig() throws IOException, CommandSyntaxException {
        if (!configFile.toFile().exists()) {
            spawnInventory = null;
            LOGGER.warn("Custom Spawn Inventory has not been configured yet! Canceling config load!");
            return;
        }
        JsonParser parser = new JsonParser();
        FileReader reader = new FileReader(configFile.toFile());
        JsonElement element = parser.parse((Reader)reader);
        IOUtils.closeQuietly((Reader)reader);
        if (!element.isJsonObject()) {
            LOGGER.warn("Detected invalid config json! Canceling config load!");
            return;
        }
        JsonObject obj = element.getAsJsonObject();
        if (obj.has("inventory") && obj.get("inventory").isJsonObject()) {
            LOGGER.info("Reading starting inventory config");
            spawnInventory = new HashMap<PlayerSlot, CompoundTag>();
            JsonObject inv = obj.get("inventory").getAsJsonObject();
            for (Map.Entry entry : inv.entrySet()) {
                PlayerSlot slot = PlayerSlot.fromString((String)entry.getKey());
                CompoundTag stack = TagParser.m_129359_((String)((JsonElement)entry.getValue()).getAsJsonPrimitive().getAsString());
                spawnInventory.put(slot, stack);
            }
            LOGGER.info("Loaded " + spawnInventory.size() + " starting items.");
        }
        if (obj.has("kits") && obj.get("kits").isJsonObject()) {
            LOGGER.info("Reading kits from config");
            JsonObject kits = obj.get("kits").getAsJsonObject();
            for (Map.Entry entry : kits.entrySet()) {
                String name = (String)entry.getKey();
                JsonObject items = ((JsonElement)entry.getValue()).getAsJsonObject();
                Map kitMap = DataManager.kits.computeIfAbsent(name, s -> new HashMap());
                for (Map.Entry kitEntry : items.entrySet()) {
                    PlayerSlot slot = PlayerSlot.fromString((String)kitEntry.getKey());
                    CompoundTag stack = TagParser.m_129359_((String)((JsonElement)kitEntry.getValue()).getAsJsonPrimitive().getAsString());
                    kitMap.put(slot, stack);
                }
                LOGGER.info("Loaded " + kitMap.size() + " items for kit " + name);
            }
        }
        if (obj.has("wipeBlacklist") && obj.get("wipeBlacklist").isJsonArray()) {
            wipeBlacklist.clear();
            obj.get("wipeBlacklist").getAsJsonArray().forEach(e -> wipeBlacklist.add(e.getAsString()));
        }
    }

    public static void givePlayerStartGear(Player player) {
        if (spawnInventory == null) {
            player.m_213846_((Component)Component.m_237113_((String)"Custom Starting Gear has not been configured!").m_130940_(ChatFormatting.DARK_RED));
            player.m_213846_((Component)Component.m_237113_((String)"If you are an operator use /csg_config to get more info."));
            return;
        }
        if (wipeBlacklist.isEmpty()) {
            player.m_150109_().m_6211_();
        } else {
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack stack = player.m_150109_().m_8020_(i);
                ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
                if (stack.m_41619_() || key == null || wipeBlacklist.contains(key.m_135827_()) || wipeBlacklist.contains(key.toString())) continue;
                player.m_150109_().m_6836_(i, ItemStack.f_41583_);
            }
        }
        for (PlayerSlot slot : spawnInventory.keySet()) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)spawnInventory.get(slot).m_6426_());
            if (slot.getStackInSlot(player).m_41619_()) {
                slot.setStackInSlot(player, stack);
                continue;
            }
            ItemEntity entity = (ItemEntity)EntityType.f_20461_.m_20615_(player.f_19853_);
            if (entity == null || player.f_19853_.f_46443_) continue;
            entity.m_32045_(stack);
            entity.m_32061_();
            entity.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
            player.f_19853_.m_7967_((Entity)entity);
        }
    }

    public static void givePlayerKit(Player player, String kit) {
        if (!kits.containsKey(kit)) {
            player.m_213846_((Component)Component.m_237113_((String)("The requested kit \"" + kit + "\" does not exist!")).m_130940_(ChatFormatting.DARK_RED));
            return;
        }
        Map<PlayerSlot, CompoundTag> kitItems = kits.get(kit);
        player.m_150109_().m_6211_();
        for (PlayerSlot slot : kitItems.keySet()) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)kitItems.get(slot).m_6426_());
            slot.setStackInSlot(player, stack);
        }
    }

    static {
        spawnInventory = null;
        kits = new LinkedHashMap<String, Map<PlayerSlot, CompoundTag>>();
        wipeBlacklist = new ArrayList<String>();
    }
}

