/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.endershelf;

import com.lothrazar.cyclic.block.endershelf.TileEnderShelf;
import com.lothrazar.cyclic.net.PacketTileInventoryToClient;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.cyclic.util.EnchantUtil;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.items.ItemStackHandler;

public class EnderShelfItemHandler
extends ItemStackHandler {
    public static ForgeConfigSpec.IntValue BOOKS_PER_ROW;
    public static final int ROWS = 5;
    public TileEnderShelf shelf;
    String[] nameCache = new String[5];
    String[] enchantmentIdCache = new String[5];
    int[] extraBooks = new int[5];

    public void resetNameCache() {
        this.nameCache = new String[5];
    }

    public EnderShelfItemHandler(TileEnderShelf shelf) {
        super(5);
        this.shelf = shelf;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        for (int i = 0; i < 5; ++i) {
            tag.m_128405_("cyclicmagic:idc" + i, this.extraBooks[i]);
            if (this.enchantmentIdCache[i] == null) {
                this.enchantmentIdCache[i] = "";
            }
            tag.m_128359_("cyclicmagic:ench", this.enchantmentIdCache[i]);
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        for (int i = 0; i < 5; ++i) {
            this.extraBooks[i] = nbt.m_128451_("cyclicmagic:idc" + i);
            this.enchantmentIdCache[i] = nbt.m_128461_("cyclicmagic:ench");
        }
    }

    public ItemStack emptySlot(int slot) {
        ItemStack returnStack = this.getStackInSlot(slot);
        this.stacks.set(slot, (Object)ItemStack.f_41583_);
        return returnStack;
    }

    public int getStackLimit(int slot, ItemStack stack) {
        return (Integer)BOOKS_PER_ROW.get();
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.shelf.m_58904_() == null) {
            return ItemStack.f_41583_;
        }
        boolean oldEmpty = ((ItemStack)this.stacks.get(slot)).m_41619_();
        ItemStack extracted = super.extractItem(slot, amount, simulate);
        boolean newEmpty = ((ItemStack)this.stacks.get(slot)).m_41619_();
        if (oldEmpty != newEmpty) {
            this.refreshId(slot);
        }
        if (!simulate) {
            PacketRegistry.sendToAllClients(this.shelf.m_58904_(), new PacketTileInventoryToClient(this.shelf.m_58899_(), slot, this.getStackInSlot(slot), PacketTileInventoryToClient.SyncPacketType.SET));
        }
        if (this.shelf.m_58904_().f_46443_ && oldEmpty != ((ItemStack)this.stacks.get(slot)).m_41619_()) {
            this.nameCache[slot] = "";
        }
        return extracted;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        boolean oldEmpty = ((ItemStack)this.stacks.get(slot)).m_41619_();
        ItemStack remaining = super.insertItem(slot, stack, simulate);
        boolean newEmpty = ((ItemStack)this.stacks.get(slot)).m_41619_();
        if (oldEmpty != newEmpty) {
            this.refreshId(slot);
        }
        if (!simulate) {
            PacketRegistry.sendToAllClients(this.shelf.m_58904_(), new PacketTileInventoryToClient(this.shelf.m_58899_(), slot, this.getStackInSlot(slot), PacketTileInventoryToClient.SyncPacketType.SET));
        }
        return remaining;
    }

    private void refreshId(int slot) {
        block1: {
            ItemStack stackIn;
            block0: {
                stackIn = this.getStackInSlot(slot);
                if (!stackIn.m_41619_()) break block0;
                this.enchantmentIdCache[slot] = "";
                break block1;
            }
            ListTag chantsIn = EnchantedBookItem.m_41163_((ItemStack)stackIn);
            this.enchantmentIdCache[slot] = ((CompoundTag)chantsIn.get(0)).m_128461_("id");
            Map enchantments = EnchantmentHelper.m_44882_((ListTag)chantsIn);
            Iterator iterator = enchantments.entrySet().iterator();
            if (!iterator.hasNext()) break block1;
            Map.Entry entry = iterator.next();
            this.nameCache[slot] = ((Enchantment)entry.getKey()).m_44700_(((Integer)entry.getValue()).intValue()).getString();
        }
    }

    public boolean isItemValid(int slot, ItemStack stackIn) {
        if (stackIn.m_41720_() != Items.f_42690_) {
            return false;
        }
        ListTag chantsIn = EnchantedBookItem.m_41163_((ItemStack)stackIn);
        if (chantsIn.size() != 1) {
            return false;
        }
        boolean oldEmpty = this.getStackInSlot(slot).m_41619_();
        if (oldEmpty) {
            return true;
        }
        ItemStack stackHere = this.getStackInSlot(slot);
        if (this.enchantmentIdCache[slot] != null || !this.enchantmentIdCache[slot].isEmpty()) {
            boolean match = this.enchantmentIdCache[slot].equals(((CompoundTag)chantsIn.get(0)).m_128461_("id"));
            return match;
        }
        return EnchantUtil.doBookEnchantmentsMatch(stackIn, stackHere);
    }
}

