/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.terrasoil;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.registry.TileRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;

public class TileTerraPreta
extends TileBlockEntityCyclic {
    public static ForgeConfigSpec.IntValue TIMER_FULL;
    public static final int HEIGHT = 16;
    public static ForgeConfigSpec.DoubleValue CHANCE;

    public TileTerraPreta(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.TERRA_PRETA.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileTerraPreta e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileTerraPreta e) {
        e.tick();
    }

    public void tick() {
        --this.timer;
        if (this.timer > 0) {
            return;
        }
        this.timer = (Integer)TIMER_FULL.get();
        for (int h = 0; h < 16; ++h) {
            BlockPos current = this.m_58899_().m_6630_(h);
            TileTerraPreta.grow(this.f_58857_, current, (Double)CHANCE.get());
        }
    }

    public static boolean grow(Level world, BlockPos current, double d) {
        if (!TileTerraPreta.isValidGrow(world, current)) {
            return false;
        }
        BlockState bState = world.m_8055_(current);
        Block block = bState.m_60734_();
        if (world instanceof ServerLevel) {
            try {
                ServerLevel sw = (ServerLevel)world;
                if (d >= 1.0 || world.f_46441_.m_188500_() < d) {
                    block.m_213898_(bState, sw, current, world.f_46441_);
                    block.m_213898_(bState, sw, current, world.f_46441_);
                    block.m_213898_(bState, sw, current, world.f_46441_);
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidGrow(Level world, BlockPos current) {
        BonemealableBlock crop;
        BlockState bState = world.m_8055_(current);
        if (!(!(bState.m_60734_() instanceof BonemealableBlock) || (crop = (BonemealableBlock)bState.m_60734_()).m_7370_((BlockGetter)world, current, bState, world.f_46443_) && crop.m_214167_(world, world.f_46441_, current, bState))) {
            return false;
        }
        return bState.m_204336_(BlockTags.f_13073_) || bState.m_204336_(BlockTags.f_13104_);
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }
}

