/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.compat.jei;

import com.lothrazar.cyclic.block.melter.RecipeMelter;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.util.ChatUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.FluidStack;

public class MelterRecipeCategory
implements IRecipeCategory<RecipeMelter> {
    private static final int FONT = 0x404040;
    private static final ResourceLocation ID = new ResourceLocation("cyclic", "melter");
    static final RecipeType<RecipeMelter> TYPE = new RecipeType(ID, RecipeMelter.class);
    private IDrawable gui;
    private IDrawable icon;

    public MelterRecipeCategory(IGuiHelper helper) {
        this.gui = helper.drawableBuilder(new ResourceLocation("cyclic", "textures/jei/melter_recipe.png"), 0, 0, 169, 69).setTextureSize(169, 69).build();
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockRegistry.MELTER.get()));
    }

    public Component getTitle() {
        return ChatUtil.ilang(((Block)BlockRegistry.MELTER.get()).m_7705_());
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.gui;
    }

    public RecipeType<RecipeMelter> getRecipeType() {
        return TYPE;
    }

    public void draw(RecipeMelter recipe, IRecipeSlotsView recipeSlotsView, PoseStack ms, double mouseX, double mouseY) {
        Minecraft.m_91087_().f_91062_.m_92883_(ms, recipe.getEnergy().getTicks() + " t", 60.0f, 0.0f, 0x404040);
        Minecraft.m_91087_().f_91062_.m_92883_(ms, recipe.getEnergy().getRfPertick() + " RF/t", 60.0f, 10.0f, 0x404040);
        Minecraft.m_91087_().f_91062_.m_92883_(ms, recipe.getEnergy().getEnergyTotal() + " RF", 60.0f, 20.0f, 0x404040);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeMelter recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 4, 19).addIngredients(recipe.at(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 22, 19).addIngredients(recipe.at(1));
        List<FluidStack> matchingFluids = List.of(recipe.getRecipeFluid());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 140, 19).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, matchingFluids);
    }
}

