/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.scythe;

import com.lothrazar.cyclic.item.scythe.ScytheType;
import com.lothrazar.cyclic.net.PacketBaseCyclic;
import com.lothrazar.cyclic.util.HarvestUtil;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class PacketScythe
extends PacketBaseCyclic {
    private BlockPos pos;
    private ScytheType type;
    private int radius;

    public PacketScythe() {
    }

    public PacketScythe(BlockPos mouseover, ScytheType t, int r) {
        this.pos = mouseover;
        this.type = t;
        this.radius = r;
    }

    public static void handle(PacketScythe message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Level world = player.m_20193_();
            List<BlockPos> shape = ScytheType.getShape(message.pos, message.radius);
            for (BlockPos posCurrent : shape) {
                HarvestUtil.harvestByScytheType(world, (Player)player, posCurrent, message.type);
            }
        });
        message.done(ctx);
    }

    public static PacketScythe decode(FriendlyByteBuf buf) {
        PacketScythe p = new PacketScythe(buf.m_130135_(), ScytheType.values()[buf.readInt()], buf.readInt());
        return p;
    }

    public static void encode(PacketScythe msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.writeInt(msg.type.ordinal());
        buf.writeInt(msg.radius);
    }
}

