/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class LootHelpers {
    private static final LootHelpers INSTANCE = new LootHelpers();
    private static final Multimap<ResourceLocation, ResourceLocation> INJECT_LOOTTABLES = MultimapBuilder.ListMultimapBuilder.hashKeys().arrayListValues().build();

    private LootHelpers() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        for (ResourceLocation injectTable : INJECT_LOOTTABLES.get((Object)event.getName())) {
            LootHelpers.injectLootTableDirect(event.getTable(), injectTable);
        }
    }

    public static void injectLootTable(ResourceLocation source, ResourceLocation ... targets) {
        for (ResourceLocation target : targets) {
            INJECT_LOOTTABLES.put((Object)target, (Object)source);
        }
    }

    public static void injectLootTableDirect(LootTable target, ResourceLocation source) {
        target.addPool(new LootPool.Builder().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)source)).name(source.toString()).m_79082_());
    }

    public static LootItemFunctionType registerFunction(ResourceLocation id, Serializer<? extends LootItemFunction> serializer) {
        return (LootItemFunctionType)Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)id, (Object)new LootItemFunctionType(serializer));
    }

    public static LootItemConditionType registerCondition(ResourceLocation id, Serializer<? extends LootItemCondition> serializer) {
        return (LootItemConditionType)Registry.m_122965_((Registry)Registry.f_122877_, (ResourceLocation)id, (Object)new LootItemConditionType(serializer));
    }
}

