/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.infobook.AdvancedButtonEnum;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.RecipeAppendix;

public class FurnaceRecipeAppendix
extends RecipeAppendix<Recipe<Container>> {
    private static final int SLOT_OFFSET_X = 16;
    private static final int SLOT_OFFSET_Y = 3;
    private static final int START_X_RESULT = 68;
    private static final AdvancedButtonEnum INPUT = AdvancedButtonEnum.create();
    private static final AdvancedButtonEnum RESULT = AdvancedButtonEnum.create();

    public FurnaceRecipeAppendix(IInfoBook infoBook, Recipe<Container> recipe) {
        super(infoBook, recipe);
    }

    @Override
    protected int getWidth() {
        return 100;
    }

    @Override
    protected int getHeightInner() {
        return 22;
    }

    @Override
    protected String getUnlocalizedTitle() {
        return "block.minecraft.furnace";
    }

    @Override
    public void bakeElement(InfoSection infoSection) {
        this.renderItemHolders.put(INPUT, new RecipeAppendix.ItemButton(this.getInfoBook()));
        this.renderItemHolders.put(RESULT, new RecipeAppendix.ItemButton(this.getInfoBook()));
        super.bakeElement(infoSection);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawElementInner(ScreenInfoBook gui, PoseStack matrixStack, int x, int y, int width, int height, int page, int mx, int my) {
        int middle = (width - 16) / 2;
        gui.drawArrowRight(matrixStack, x + middle - 3, y + 3 + 2);
        int tick = this.getTick(gui);
        ItemStack input = this.prepareItemStacks(Lists.newArrayList((Object[])((Ingredient)((Recipe)this.recipe).m_7527_().get(0)).m_43908_()), tick);
        ItemStack result = this.prepareItemStack(((Recipe)this.recipe).m_8043_(), tick);
        this.renderItem(gui, matrixStack, x + 16, y + 3, input, mx, my, INPUT);
        this.renderItem(gui, matrixStack, x + 68, y + 3, result, mx, my, RESULT);
        this.renderItem(gui, matrixStack, x + middle, y + 3, new ItemStack((ItemLike)Blocks.f_50094_), mx, my, false, null);
    }
}

