/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.block;

import com.mojang.serialization.DynamicOps;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import novamachina.exnihilosequentia.common.init.ExNihiloFluids;

public class WitchWaterBlock
extends LiquidBlock {
    public WitchWaterBlock() {
        super(ExNihiloFluids.WITCH_WATER, BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60910_().m_60978_(100.0f).m_222994_());
    }

    @Deprecated
    public void m_7892_(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Entity entityIn) {
        LightningBolt lightningBolt;
        if (worldIn.m_5776_() || !entityIn.m_6084_()) {
            return;
        }
        if (entityIn instanceof Skeleton) {
            this.replaceMob(worldIn, (LivingEntity)((Skeleton)entityIn), (LivingEntity)new WitherSkeleton(EntityType.f_20497_, worldIn));
        }
        if (entityIn instanceof Creeper && !((Creeper)entityIn).m_7090_()) {
            entityIn.m_8038_((ServerLevel)worldIn, (LightningBolt)EntityType.f_20465_.m_20615_(worldIn));
            ((Creeper)entityIn).m_21153_(((Creeper)entityIn).m_21233_());
        }
        if (entityIn instanceof Spider && !(entityIn instanceof CaveSpider)) {
            this.replaceMob(worldIn, (LivingEntity)((Spider)entityIn), (LivingEntity)new CaveSpider(EntityType.f_20554_, worldIn));
        }
        if (entityIn instanceof Squid) {
            this.replaceMob(worldIn, (LivingEntity)((Squid)entityIn), (LivingEntity)new Ghast(EntityType.f_20453_, worldIn));
        }
        if (entityIn instanceof Villager) {
            Villager villagerEntity = (Villager)entityIn;
            VillagerProfession profession = villagerEntity.m_7141_().m_35571_();
            if (profession == VillagerProfession.f_35589_) {
                this.replaceMob(worldIn, (LivingEntity)villagerEntity, (LivingEntity)new Witch(EntityType.f_20495_, worldIn));
            } else if (profession == VillagerProfession.f_35587_) {
                this.replaceMob(worldIn, (LivingEntity)villagerEntity, (LivingEntity)new Vindicator(EntityType.f_20493_, worldIn));
            } else if (profession == VillagerProfession.f_35594_) {
                this.replaceMob(worldIn, (LivingEntity)villagerEntity, (LivingEntity)new Evoker(EntityType.f_20568_, worldIn));
            } else {
                ZombieVillager zombieVillagerEntity = new ZombieVillager(EntityType.f_20530_, worldIn);
                zombieVillagerEntity.m_34375_(villagerEntity.m_7141_());
                zombieVillagerEntity.m_34391_((Tag)villagerEntity.m_35517_().m_26179_((DynamicOps)NbtOps.f_128958_).getValue());
                zombieVillagerEntity.m_34411_(villagerEntity.m_6616_().m_45388_());
                zombieVillagerEntity.m_34373_(villagerEntity.m_7809_());
                this.replaceMob(worldIn, (LivingEntity)villagerEntity, (LivingEntity)zombieVillagerEntity);
            }
        }
        if (entityIn instanceof Animal && (lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(worldIn)) != null) {
            entityIn.m_8038_((ServerLevel)worldIn, lightningBolt);
        }
        if (entityIn instanceof Player) {
            this.applyPotion((Player)entityIn, new MobEffectInstance(MobEffects.f_19610_, 210, 0));
            this.applyPotion((Player)entityIn, new MobEffectInstance(MobEffects.f_19613_, 210, 2));
            this.applyPotion((Player)entityIn, new MobEffectInstance(MobEffects.f_19615_, 210, 0));
            this.applyPotion((Player)entityIn, new MobEffectInstance(MobEffects.f_19597_, 210, 0));
        }
    }

    private void applyPotion(@Nonnull Player entityIn, @Nonnull MobEffectInstance potionEffect) {
        MobEffectInstance currentEffect = entityIn.m_21124_(potionEffect.m_19544_());
        if (currentEffect != null && currentEffect.m_19557_() <= potionEffect.m_19557_() - 20) {
            entityIn.m_7292_(potionEffect);
        }
    }

    private void replaceMob(@Nonnull Level world, @Nonnull LivingEntity toKill, @Nonnull LivingEntity toSpawn) {
        toSpawn.m_7678_(toKill.m_20185_(), toKill.m_20186_(), toKill.m_20189_(), toKill.m_146908_(), toKill.m_146909_());
        toSpawn.f_20883_ = toKill.f_20883_;
        toSpawn.m_21153_(toSpawn.m_21233_() * toKill.m_21223_() / toKill.m_21233_());
        toKill.m_142687_(Entity.RemovalReason.DISCARDED);
        world.m_7967_((Entity)toSpawn);
    }
}

