/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.blockentity.barrel.mode;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import novamachina.exnihilosequentia.common.blockentity.barrel.AbstractBarrelEntity;
import novamachina.exnihilosequentia.common.blockentity.barrel.mode.AbstractBarrelMode;
import novamachina.exnihilosequentia.common.registries.ExNihiloRegistries;
import novamachina.exnihilosequentia.common.utility.Config;
import novamachina.exnihilosequentia.common.utility.StringUtils;

public class FluidTransformBarrelMode
extends AbstractBarrelMode {
    private int currentProgress = 0;
    @Nullable
    private ItemLike catalyst;

    public FluidTransformBarrelMode(String name) {
        super(name);
    }

    public void setCatalyst(@Nonnull ItemLike catalyst) {
        this.catalyst = catalyst;
    }

    @Override
    public void tick(@Nonnull AbstractBarrelEntity barrelTile) {
        Fluid fluidInTank = barrelTile.getTank().getFluid().getFluid();
        ++this.currentProgress;
        this.spawnParticle(barrelTile);
        if (this.currentProgress >= Config.getSecondsToFluidTransform() * 20) {
            this.currentProgress = 0;
            Fluid newFluid = ExNihiloRegistries.FLUID_TRANSFORM_REGISTRY.getResult(fluidInTank, this.catalyst);
            barrelTile.getTank().setFluid(new FluidStack(newFluid, AbstractBarrelEntity.MAX_FLUID_AMOUNT));
            barrelTile.setMode("fluid");
        }
    }

    @Override
    @Nonnull
    public InteractionResult onBlockActivated(@Nonnull AbstractBarrelEntity barrelTile, @Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull IFluidHandler fluidHandler, @Nonnull IItemHandler itemHandler) {
        return InteractionResult.PASS;
    }

    @Override
    public boolean canFillWithFluid(@Nonnull AbstractBarrelEntity barrel) {
        return false;
    }

    @Override
    public boolean isEmptyMode() {
        return false;
    }

    @Override
    protected boolean isTriggerItem(@Nonnull ItemStack stack) {
        return false;
    }

    @Override
    public void read(@Nonnull CompoundTag nbt) {
        this.currentProgress = nbt.m_128451_("currentProgress");
        this.catalyst = ItemStack.m_41712_((CompoundTag)nbt).m_41720_();
    }

    @Override
    @Nonnull
    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("currentProgress", this.currentProgress);
        new ItemStack(this.catalyst).m_41739_(nbt);
        return nbt;
    }

    @Override
    protected void spawnParticle(@Nonnull AbstractBarrelEntity barrelTile) throws NullPointerException {
        ServerLevel level = (ServerLevel)barrelTile.m_58904_();
        Preconditions.checkNotNull((Object)level, (Object)"Level is null.");
        level.m_8767_((ParticleOptions)ParticleTypes.f_123806_, (double)barrelTile.m_58899_().m_123341_() + barrelTile.m_58904_().f_46441_.m_188500_(), (double)barrelTile.m_58899_().m_123342_() + barrelTile.m_58904_().f_46441_.m_188500_(), (double)barrelTile.m_58899_().m_123343_() + barrelTile.m_58904_().f_46441_.m_188500_(), 1, 0.0, 0.0, 0.0, 0.05);
    }

    @Override
    @Nonnull
    public List<Component> getWailaInfo(@Nonnull AbstractBarrelEntity barrelTile) {
        ArrayList<Component> info = new ArrayList<Component>();
        info.add((Component)Component.m_237110_((String)"waila.progress", (Object[])new Object[]{StringUtils.formatPercent(Float.valueOf((float)this.currentProgress / (float)(Config.getSecondsToFluidTransform() * 20)))}));
        return info;
    }

    @Override
    @Nonnull
    public ItemStack handleInsert(@Nonnull AbstractBarrelEntity barrelTile, @Nonnull ItemStack stack, boolean simulate) {
        return stack;
    }
}

