/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.blockentity.crucible;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import novamachina.exnihilosequentia.common.blockentity.IFluidContainer;
import novamachina.exnihilosequentia.common.blockentity.crucible.CrucibleFluidHandler;
import novamachina.exnihilosequentia.common.blockentity.crucible.CrucibleTypeEnum;
import novamachina.exnihilosequentia.common.blockentity.crucible.MeltableItemHandler;
import novamachina.exnihilosequentia.common.crafting.crucible.CrucibleRecipe;
import novamachina.exnihilosequentia.common.registries.ExNihiloRegistries;
import novamachina.exnihilosequentia.common.utility.Config;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import novamachina.exnihilosequentia.common.utility.TankUtil;

public abstract class BaseCrucibleEntity
extends BlockEntity
implements IFluidContainer {
    protected static final int MAX_FLUID_AMOUNT = Config.getCrucibleNumberOfBuckets() * 1000;
    @Nonnull
    private static final String BLOCK_TAG = "block";
    @Nonnull
    private static final String CURRENT_ITEM_TAG = "currentItem";
    @Nonnull
    private static final String FLUID_TAG = "fluid";
    @Nonnull
    private static final String INVENTORY_TAG = "inventory";
    @Nonnull
    private static final String SOLID_AMOUNT_TAG = "solidAmount";
    @Nonnull
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogUtils.getLogger());
    @Nonnull
    protected ItemStack currentItem;
    @Nonnull
    protected MeltableItemHandler inventory;
    @Nonnull
    private final LazyOptional<IItemHandler> inventoryHolder = LazyOptional.of(() -> this.inventory);
    @Nullable
    protected BaseCrucibleTileState lastSyncedState = null;
    protected int solidAmount = 0;
    @Nonnull
    protected CrucibleFluidHandler tank;
    @Nonnull
    private final LazyOptional<IFluidHandler> tankHolder = LazyOptional.of(() -> this.tank);
    protected int ticksSinceLast = 0;

    protected BaseCrucibleEntity(BlockEntityType<? extends BaseCrucibleEntity> tileEntityType, BlockPos pos, BlockState state) {
        super(tileEntityType, pos, state);
        this.inventory = new MeltableItemHandler(this.getCrucibleType());
        this.tank = new CrucibleFluidHandler(this);
        this.currentItem = ItemStack.f_41583_;
    }

    public abstract boolean canAcceptFluidTemperature(@Nonnull FluidStack var1);

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHolder.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tankHolder.cast();
        }
        return super.getCapability(cap, side);
    }

    public abstract CrucibleTypeEnum getCrucibleType();

    @Nonnull
    public ItemStack getCurrentItem() {
        return this.currentItem;
    }

    @Nullable
    public Fluid getFluid() {
        if (!this.tank.isEmpty()) {
            return this.tank.getFluid().getFluid();
        }
        return null;
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }

    @Override
    public float getFluidProportion() {
        return (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
    }

    public int getHeat() {
        if (this.f_58857_ == null) {
            return 0;
        }
        BlockState source = this.f_58857_.m_8055_(this.f_58858_.m_7495_());
        int blockHeat = ExNihiloRegistries.HEAT_REGISTRY.getHeatAmount(source);
        if (source.m_60734_() instanceof LiquidBlock) {
            int level = 8 - (Integer)source.m_61143_((Property)BlockStateProperties.f_61422_);
            double partial = (double)blockHeat / 8.0;
            return (int)Math.ceil(partial * (double)level);
        }
        return blockHeat;
    }

    @Nullable
    private CrucibleRecipe getMeltable() {
        return ExNihiloRegistries.CRUCIBLE_REGISTRY.findRecipeByItemStack(this.currentItem).orElse(null);
    }

    public abstract int getSolidAmount();

    public float getSolidProportion() {
        try {
            CrucibleRecipe meltable;
            int itemCount = this.inventory.getStackInSlot(0).m_41619_() ? 0 : this.inventory.getStackInSlot(0).m_41613_();
            float solidProportion = (float)itemCount / 4.0f;
            if (this.solidAmount > 0 && (meltable = this.getMeltable()) != null) {
                solidProportion += (float)this.solidAmount / (float)(4 * meltable.getAmount());
            }
            return solidProportion;
        }
        catch (NullPointerException e) {
            logger.error(e.getMessage());
            return 0.0f;
        }
    }

    @Nonnull
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        if (!this.inventory.getStackInSlot(0).m_41619_()) {
            CompoundTag blockNbt = this.inventory.getStackInSlot(0).m_41739_(new CompoundTag());
            nbt.m_128365_(BLOCK_TAG, (Tag)blockNbt);
        }
        if (!this.currentItem.m_41619_()) {
            CompoundTag currentItemTag = this.currentItem.m_41739_(new CompoundTag());
            nbt.m_128365_(CURRENT_ITEM_TAG, (Tag)currentItemTag);
        }
        if (!this.tank.isEmpty()) {
            CompoundTag fluidNbt = this.tank.writeToNBT(new CompoundTag());
            nbt.m_128365_(FLUID_TAG, (Tag)fluidNbt);
        }
        nbt.m_128405_(SOLID_AMOUNT_TAG, this.solidAmount);
        return nbt;
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        this.inventory.deserializeNBT(compound.m_128469_(INVENTORY_TAG));
        this.tank.readFromNBT(compound.m_128469_("tank"));
        this.ticksSinceLast = compound.m_128451_("ticksSinceLast");
        this.solidAmount = compound.m_128451_(SOLID_AMOUNT_TAG);
        this.currentItem = ItemStack.m_41712_((CompoundTag)compound.m_128469_(CURRENT_ITEM_TAG));
        super.m_142466_(compound);
    }

    public InteractionResult onBlockActivated(@Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull IFluidHandler handler) {
        logger.debug("Crucible activated");
        ItemStack stack = player.m_21120_(handIn);
        if (stack.m_41619_()) {
            return InteractionResult.SUCCESS;
        }
        if (TankUtil.drainWaterIntoBottle(this, player, handler)) {
            return InteractionResult.SUCCESS;
        }
        if (TankUtil.drainWaterFromBottle(this, player, handler)) {
            return InteractionResult.SUCCESS;
        }
        boolean result = FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)handIn, (IFluidHandler)handler);
        if (result) {
            logger.debug("Fluid handler interaction successful");
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
            }
            this.m_6596_();
            return InteractionResult.SUCCESS;
        }
        CrucibleRecipe recipe = this.getMeltable();
        if (recipe != null && !this.tank.isEmpty() && !this.tank.getFluid().getFluid().m_6212_(recipe.getResultFluid().getFluid())) {
            return InteractionResult.SUCCESS;
        }
        logger.debug("Inserting item");
        ItemStack addStack = stack.m_41777_();
        addStack.m_41764_(1);
        ItemStack insertStack = this.inventory.insertItem(0, addStack, true);
        if (!ItemStack.m_41728_((ItemStack)addStack, (ItemStack)insertStack)) {
            this.inventory.insertItem(0, addStack, false);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.m_6596_();
            this.tickCrucible();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public void onDataPacket(@Nonnull Connection net, @Nonnull ClientboundBlockEntityDataPacket packet) {
        Tag currentItemTag;
        CompoundTag nbt = packet.m_131708_();
        this.currentItem = nbt.m_128441_(CURRENT_ITEM_TAG) ? ((currentItemTag = nbt.m_128423_(CURRENT_ITEM_TAG)) != null ? ItemStack.m_41712_((CompoundTag)((CompoundTag)currentItemTag)) : ItemStack.f_41583_) : ItemStack.f_41583_;
        if (nbt.m_128441_(BLOCK_TAG)) {
            Tag blockTag = nbt.m_128423_(BLOCK_TAG);
            if (blockTag != null) {
                this.inventory.setStackInSlot(0, ItemStack.m_41712_((CompoundTag)((CompoundTag)blockTag)));
            } else {
                this.inventory.setStackInSlot(0, ItemStack.f_41583_);
            }
        } else {
            this.inventory.setStackInSlot(0, ItemStack.f_41583_);
        }
        if (nbt.m_128441_(FLUID_TAG)) {
            this.tank.readFromNBT(nbt.m_128469_(FLUID_TAG));
        } else {
            this.tank.setFluid(FluidStack.EMPTY);
        }
        this.solidAmount = nbt.m_128451_(SOLID_AMOUNT_TAG);
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        compound.m_128365_(INVENTORY_TAG, (Tag)this.inventory.serializeNBT());
        compound.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        compound.m_128405_("ticksSinceLast", this.ticksSinceLast);
        compound.m_128405_(SOLID_AMOUNT_TAG, this.solidAmount);
        compound.m_128365_(CURRENT_ITEM_TAG, (Tag)this.currentItem.m_41739_(new CompoundTag()));
    }

    public void tickServer() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.inventory.setCrucibleHasRoom(this.tank.getFluidAmount() < MAX_FLUID_AMOUNT);
        ++this.ticksSinceLast;
        if (this.ticksSinceLast >= Config.getTicksBetweenMelts()) {
            this.ticksSinceLast = 0;
            this.tickCrucible();
        }
        this.updateCurrentState();
    }

    private void updateCurrentState() {
        BaseCrucibleTileState currentState = new BaseCrucibleTileState(this);
        if (!currentState.equals(this.lastSyncedState)) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
            this.lastSyncedState = currentState;
        }
    }

    protected void tickCrucible() {
        int heat = this.getHeat();
        if (heat <= 0) {
            return;
        }
        if (this.solidAmount <= 0) {
            if (!this.inventory.getStackInSlot(0).m_41619_()) {
                this.consumeNewSolid();
            } else {
                return;
            }
        }
        if (!this.inventory.getStackInSlot(0).m_41619_() && this.inventory.getStackInSlot(0).m_41656_(this.currentItem)) {
            this.addFluid(heat);
        }
        if (heat > this.solidAmount) {
            heat = this.solidAmount;
        }
        if (heat > 0 && ExNihiloRegistries.CRUCIBLE_REGISTRY.isMeltableByItemStack(this.currentItem, this.getCrucibleType().getLevel())) {
            this.processSolid(heat);
        }
    }

    protected abstract void processSolid(int var1);

    private void addFluid(int heat) {
        while (heat > this.solidAmount && !this.inventory.getStackInSlot(0).m_41619_()) {
            Optional<CrucibleRecipe> recipe = ExNihiloRegistries.CRUCIBLE_REGISTRY.findRecipeByItemStack(this.currentItem);
            if (!recipe.isPresent()) continue;
            this.solidAmount += recipe.get().getAmount();
            this.inventory.getStackInSlot(0).m_41774_(1);
            if (!this.inventory.getStackInSlot(0).m_41619_()) continue;
            this.inventory.setStackInSlot(0, ItemStack.f_41583_);
        }
    }

    protected abstract void consumeNewSolid();

    protected static class BaseCrucibleTileState {
        @Nullable
        private final Fluid fluid;
        private final int fluidAmount;
        private final int heat;
        @Nonnull
        private final Item solid;
        private final int solidAmount;

        BaseCrucibleTileState(@Nonnull BaseCrucibleEntity baseCrucibleEntity) {
            this.fluid = baseCrucibleEntity.getFluid();
            this.fluidAmount = baseCrucibleEntity.getFluidAmount();
            this.solid = baseCrucibleEntity.inventory.getStackInSlot(0).m_41720_();
            this.solidAmount = baseCrucibleEntity.getSolidAmount();
            this.heat = baseCrucibleEntity.getHeat();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaseCrucibleTileState that = (BaseCrucibleTileState)o;
            return this.fluidAmount == that.fluidAmount && this.solidAmount == that.solidAmount && this.heat == that.heat && Objects.equals(this.fluid, that.fluid) && Objects.equals(this.solid, that.solid);
        }

        public int hashCode() {
            return Objects.hash(this.fluid, this.fluidAmount, this.solid, this.solidAmount, this.heat);
        }
    }
}

