/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.blockentity.crucible;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import novamachina.exnihilosequentia.common.blockentity.crucible.BaseCrucibleEntity;
import novamachina.exnihilosequentia.common.blockentity.crucible.CrucibleTypeEnum;
import novamachina.exnihilosequentia.common.crafting.crucible.CrucibleRecipe;
import novamachina.exnihilosequentia.common.init.ExNihiloBlockEntities;
import novamachina.exnihilosequentia.common.registries.ExNihiloRegistries;

public class FiredCrucibleEntity
extends BaseCrucibleEntity {
    public FiredCrucibleEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends FiredCrucibleEntity>)((BlockEntityType)ExNihiloBlockEntities.FIRED_CURICLBE_ENTITY.get()), pos, state);
    }

    public FiredCrucibleEntity(BlockEntityType<? extends FiredCrucibleEntity> tile, BlockPos pos, BlockState state) {
        super(tile, pos, state);
    }

    @Override
    @Nonnull
    public CrucibleTypeEnum getCrucibleType() {
        return CrucibleTypeEnum.FIRED;
    }

    @Override
    public int getSolidAmount() {
        if (!this.currentItem.m_41619_()) {
            int itemCount = this.inventory.getStackInSlot(0).m_41613_();
            CrucibleRecipe recipe = ExNihiloRegistries.CRUCIBLE_REGISTRY.findRecipeByItemStack(this.currentItem).orElse(null);
            if (recipe != null) {
                return this.solidAmount + itemCount * recipe.getAmount();
            }
        }
        return this.solidAmount;
    }

    @Override
    public boolean canAcceptFluidTemperature(@Nonnull FluidStack fluidStack) {
        return true;
    }

    @Override
    protected void processSolid(int heat) {
        Optional<CrucibleRecipe> recipe = ExNihiloRegistries.CRUCIBLE_REGISTRY.findRecipeByItemStack(this.currentItem);
        if (recipe.isPresent()) {
            FluidStack fluidStack = new FluidStack(recipe.get().getResultFluid(), heat);
            int filled = this.tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            this.solidAmount -= filled;
        }
    }

    @Override
    protected void consumeNewSolid() {
        this.currentItem = this.inventory.getStackInSlot(0).m_41777_();
        this.inventory.getStackInSlot(0).m_41774_(1);
        if (this.inventory.getStackInSlot(0).m_41619_()) {
            this.inventory.setStackInSlot(0, ItemStack.f_41583_);
        }
        ExNihiloRegistries.CRUCIBLE_REGISTRY.findRecipeByItemStack(this.currentItem).ifPresent(recipe -> {
            this.solidAmount = recipe.getAmount();
        });
    }
}

