/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.compat.jei.heat;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import novamachina.exnihilosequentia.common.crafting.heat.HeatRecipe;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;

public class HeatRecipeCategory
implements IRecipeCategory<HeatRecipe> {
    @Nonnull
    public static final ResourceLocation UID = new ResourceLocation("exnihilosequentia", "heat");
    @Nonnull
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogUtils.getLogger());
    @Nonnull
    private final IDrawableStatic background;

    public HeatRecipeCategory(@Nonnull IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(new ResourceLocation("jei", "textures/gui/gui_vanilla.png"), 0, 134, 18, 34).addPadding(0, 0, 0, 80).build();
    }

    public void draw(HeatRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.f_91062_.m_92883_(stack, recipe.getAmount() + "X", 24.0f, 12.0f, Color.gray.getRGB());
        Block block = recipe.getInput();
        if (block == Blocks.f_50082_) {
            minecraft.f_91062_.m_92883_(stack, "Wall Torch", 24.0f, 0.0f, Color.DARK_GRAY.getRGB());
        } else if (block == Blocks.f_50123_) {
            minecraft.f_91062_.m_92883_(stack, "Redstone Wall Torch", 24.0f, 0.0f, Color.DARK_GRAY.getRGB());
        } else if (block != null) {
            minecraft.f_91062_.m_92889_(stack, (Component)block.m_49954_(), 24.0f, 0.0f, Color.DARK_GRAY.getRGB());
        }
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return null;
    }

    public RecipeType<HeatRecipe> getRecipeType() {
        return new RecipeType(UID, HeatRecipe.class);
    }

    @Nonnull
    public Component getTitle() {
        return Component.m_237113_((String)"Crucible Heat Sources");
    }

    public void setRecipe(IRecipeLayoutBuilder builder, HeatRecipe recipe, IFocusGroup focuses) {
        Block recipeInput = recipe.getInput();
        if (recipeInput == null) {
            return;
        }
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)recipeInput);
        if (ForgeRegistries.FLUIDS.containsKey(blockId)) {
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(blockId);
            if (fluid != null) {
                builder.addSlot(RecipeIngredientRole.INPUT, 1, 17).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)new FluidStack(fluid, 1000));
            }
        } else {
            Block input = recipe.getInput();
            if (input == Blocks.f_50083_ || input == Blocks.f_50084_) {
                input = Items.f_42409_;
            }
            if (input instanceof LiquidBlock) {
                LiquidBlock liquidBlock = (LiquidBlock)input;
                input = liquidBlock.getFluid().m_6859_();
            }
            builder.addSlot(RecipeIngredientRole.INPUT, 1, 17).addIngredients(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}));
        }
    }
}

