/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.crafting;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import novamachina.exnihilosequentia.common.crafting.ItemStackWithChance;
import novamachina.exnihilosequentia.common.utility.FluidStackUtils;

public abstract class ExNihiloFinishedRecipe<R extends ExNihiloFinishedRecipe<R>>
implements FinishedRecipe {
    @Nonnull
    private final RecipeSerializer<?> serializer;
    @Nonnull
    private final List<Consumer<JsonObject>> writerFunctions;
    @Nullable
    protected JsonArray conditions = null;
    @Nullable
    protected JsonArray inputArray = null;
    protected int inputCount = 0;
    protected int maxInputCount = 1;
    protected int maxOutputCount = 1;
    @Nullable
    protected JsonArray outputArray = null;
    protected int outputCount = 0;
    @Nullable
    private ResourceLocation id;

    protected ExNihiloFinishedRecipe(@Nonnull RecipeSerializer<?> serializer) {
        this.serializer = serializer;
        this.writerFunctions = new ArrayList<Consumer<JsonObject>>();
    }

    @Nonnull
    public R addFluid(@Nonnull String id, @Nonnull FluidStack fluidStack) {
        return this.addWriter(jsonObject -> jsonObject.add(id, FluidStackUtils.jsonSerializeFluidStack(fluidStack)));
    }

    @Nonnull
    public R addResult(@Nonnull ItemStack itemStack) {
        if (this.outputArray != null) {
            return this.addMultiResult((JsonElement)this.serializeItemStack(itemStack));
        }
        return this.addItem("result", itemStack);
    }

    @Nonnull
    public R addResult(@Nonnull ItemLike result) {
        return this.addResult(new ItemStack(result));
    }

    @Nonnull
    public R addWriter(@Nonnull Consumer<JsonObject> writer) throws IllegalArgumentException {
        Preconditions.checkArgument((this.id == null ? 1 : 0) != 0, (Object)"This recipe has already been finalized.");
        this.writerFunctions.add(writer);
        return (R)this;
    }

    public void build(@Nonnull Consumer<FinishedRecipe> out, @Nonnull ResourceLocation id) throws IllegalArgumentException {
        Preconditions.checkArgument((boolean)this.isComplete(), (Object)"This recipe is incomplete.");
        this.id = id;
        out.accept(this);
    }

    @Nullable
    public ResourceLocation m_6448_() {
        return null;
    }

    @Nullable
    public JsonObject m_5860_() {
        return null;
    }

    @Nonnull
    public ResourceLocation m_6445_() throws NullPointerException {
        Preconditions.checkNotNull((Object)this.id, (Object)"This recipe has no id");
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_6637_() {
        return this.serializer;
    }

    public void m_7917_(@Nonnull JsonObject json) {
        for (Consumer<JsonObject> writer : this.writerFunctions) {
            writer.accept(json);
        }
    }

    @Nonnull
    public R setMultipleResults(int maxResultCount) {
        this.outputArray = new JsonArray();
        this.maxOutputCount = maxResultCount;
        return this.addWriter(jsonObject -> jsonObject.add("results", (JsonElement)this.outputArray));
    }

    @Nonnull
    protected R addBlock(@Nonnull Block block) {
        ResourceLocation resourceLocation = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (resourceLocation != null) {
            return this.addWriter(jsonObject -> jsonObject.addProperty("block", resourceLocation.toString()));
        }
        return (R)this;
    }

    @Nonnull
    protected R addBoolean(@Nonnull String key, boolean value) {
        return this.addWriter(jsonObject -> jsonObject.addProperty(key, Boolean.valueOf(value)));
    }

    @Nonnull
    protected R addFluid(@Nonnull Fluid fluid) {
        return this.addFluid("fluid", new FluidStack(fluid, 1000));
    }

    @Nonnull
    protected R addFluid(@Nonnull String id, @Nonnull Fluid fluid) {
        return this.addFluid(id, new FluidStack(fluid, 1000));
    }

    @Nonnull
    protected R addInput(@Nonnull ItemStack input) {
        if (this.inputArray != null) {
            return this.addMultiInput((JsonElement)this.serializeItemStack(input));
        }
        return this.addItem("input", input);
    }

    @Nonnull
    protected R addInput(@Nonnull Ingredient input) {
        return this.addInput("input", input);
    }

    @Nonnull
    protected R addInput(@Nonnull String key, @Nonnull Ingredient input) {
        if (this.inputArray != null) {
            return this.addMultiInput(input.m_43942_());
        }
        return this.addItem(key, input);
    }

    @Nonnull
    protected R addInput(@Nonnull ItemLike input) {
        return this.addInput(new ItemStack(input));
    }

    @Nonnull
    protected R addInput(@Nonnull TagKey<Item> tag) {
        return this.addInput(Ingredient.m_204132_(tag));
    }

    @Nonnull
    protected R addInput(@Nonnull String id, @Nonnull ItemLike block) {
        return this.addItem(id, new ItemStack(block));
    }

    @Nonnull
    protected R addResult(@Nonnull ItemStackWithChance itemStack) {
        if (this.outputArray != null) {
            return this.addMultiResult(itemStack.serialize());
        }
        return this.addItem("result", itemStack.serialize());
    }

    protected boolean isComplete() {
        return true;
    }

    @Nonnull
    private R addItem(@Nonnull String key, @Nonnull ItemStack itemStack) throws IllegalArgumentException {
        Preconditions.checkArgument((!itemStack.m_41619_() ? 1 : 0) != 0, (Object)"ItemStack cannot be empty.");
        return this.addWriter(jsonObj -> jsonObj.add(key, (JsonElement)this.serializeItemStack(itemStack)));
    }

    @Nonnull
    private R addItem(@Nonnull String key, @Nonnull Ingredient ingredient) {
        return this.addWriter(jsonObj -> jsonObj.add(key, ingredient.m_43942_()));
    }

    @Nonnull
    private R addItem(@Nonnull String key, @Nonnull JsonElement obj) {
        return this.addWriter(jsonObj -> jsonObj.add(key, obj));
    }

    @Nonnull
    private R addMultiInput(@Nonnull JsonElement obj) throws IllegalArgumentException {
        Preconditions.checkArgument((this.maxInputCount > 1 ? 1 : 0) != 0, (Object)"This recipe does not support multiple inputs.");
        Preconditions.checkArgument((this.inputCount < this.maxInputCount ? 1 : 0) != 0, (Object)("This recipe can only have " + this.maxInputCount + "inputs."));
        if (this.inputArray != null) {
            this.inputArray.add(obj);
            ++this.inputCount;
        }
        return (R)this;
    }

    @Nonnull
    private R addMultiResult(@Nonnull JsonElement obj) throws IllegalArgumentException {
        Preconditions.checkArgument((this.maxOutputCount > 1 ? 1 : 0) != 0, (Object)"This recipe does not support multiple results.");
        Preconditions.checkArgument((this.outputCount < this.maxOutputCount ? 1 : 0) != 0, (Object)("This recipe can only have " + this.maxOutputCount + "results."));
        if (this.outputArray != null) {
            this.outputArray.add(obj);
            ++this.outputCount;
        }
        return (R)this;
    }

    @Nonnull
    private JsonObject serializeItemStack(@Nonnull ItemStack itemStack) {
        JsonObject obj = new JsonObject();
        ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
        if (resourceLocation != null) {
            obj.addProperty("item", resourceLocation.toString());
        }
        if (itemStack.m_41613_() > 1) {
            obj.addProperty("count", (Number)itemStack.m_41613_());
        }
        if (itemStack.m_41782_() && itemStack.m_41783_() != null) {
            obj.addProperty("nbt", itemStack.m_41783_().toString());
        }
        return obj;
    }
}

