/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemStackWithChance {
    @Nonnull
    private static final String BASE_KEY = "item";
    @Nonnull
    private static final String CHANCE_KEY = "chance";
    @Nonnull
    private static final String COUNT_KEY = "count";
    private final float chance;
    @Nonnull
    private final ItemStack itemStack;

    public ItemStackWithChance(@Nonnull ItemStack itemStack, float chance) {
        this.itemStack = itemStack;
        this.chance = chance;
    }

    @Nonnull
    public static ItemStackWithChance deserialize(@Nonnull JsonElement json) {
        if (json.isJsonObject() && json.getAsJsonObject().has(BASE_KEY)) {
            float chance = GsonHelper.m_13820_((JsonObject)json.getAsJsonObject(), (String)CHANCE_KEY, (float)1.0f);
            String itemString = GsonHelper.m_13906_((JsonObject)json.getAsJsonObject(), (String)BASE_KEY);
            int count = 1;
            if (json.getAsJsonObject().has(COUNT_KEY)) {
                count = json.getAsJsonObject().get(COUNT_KEY).getAsInt();
            }
            return new ItemStackWithChance(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemString)), count), chance);
        }
        String itemString = GsonHelper.m_13805_((JsonElement)json, (String)BASE_KEY);
        return new ItemStackWithChance(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemString))), 1.0f);
    }

    @Nonnull
    public static ItemStackWithChance read(@Nonnull FriendlyByteBuf buffer) {
        ItemStack stack = buffer.m_130267_();
        float chance = buffer.readFloat();
        return new ItemStackWithChance(stack, chance);
    }

    public float getChance() {
        return this.chance;
    }

    @Nonnull
    public ItemStack getStack() {
        return this.itemStack.m_41777_();
    }

    @Nonnull
    public JsonElement serialize() {
        JsonObject json = new JsonObject();
        json.addProperty(CHANCE_KEY, (Number)Float.valueOf(this.getChance()));
        ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((Object)this.getStack().m_41720_());
        if (resourceLocation != null) {
            json.addProperty(BASE_KEY, resourceLocation.toString());
        }
        json.addProperty(COUNT_KEY, (Number)this.getStack().m_41613_());
        return json;
    }

    public void write(@Nonnull FriendlyByteBuf buffer) {
        buffer.m_130055_(this.getStack());
        buffer.writeFloat(this.getChance());
    }
}

