/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.crafting.hammer;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import novamachina.exnihilosequentia.common.crafting.ExNihiloRecipeSerializer;
import novamachina.exnihilosequentia.common.crafting.ItemStackWithChance;
import novamachina.exnihilosequentia.common.crafting.SingleItemSerializableRecipe;
import novamachina.exnihilosequentia.common.init.ExNihiloRecipeTypes;
import novamachina.exnihilosequentia.common.init.ExNihiloSerializers;

public class HammerRecipe
extends SingleItemSerializableRecipe {
    @Nonnull
    public static final HammerRecipe EMPTY = new HammerRecipe(new ResourceLocation("empty"), Ingredient.f_43901_, new ArrayList<ItemStackWithChance>());
    @Nonnull
    private final List<ItemStackWithChance> output;

    public HammerRecipe(@Nonnull ResourceLocation id, @Nonnull Ingredient input, @Nonnull List<ItemStackWithChance> output) {
        super(ItemStack.f_41583_, input, (RecipeType)ExNihiloRecipeTypes.HAMMER_RECIPE_TYPE.get(), id);
        this.output = output;
    }

    public void addOutput(@Nonnull ItemStack output) {
        this.output.add(new ItemStackWithChance(output, 1.0f));
    }

    public void addOutput(@Nonnull ItemStack output, float chance) {
        this.output.add(new ItemStackWithChance(output, chance));
    }

    @Nonnull
    public List<ItemStackWithChance> getOutput() {
        return this.output;
    }

    @Nonnull
    public List<ItemStack> getOutputsWithoutChance() {
        ArrayList<ItemStack> returnList = new ArrayList<ItemStack>();
        this.output.forEach(stack -> returnList.add(stack.getStack()));
        return returnList;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    @Nullable
    protected ExNihiloRecipeSerializer<HammerRecipe> getENSerializer() {
        return (ExNihiloRecipeSerializer)ExNihiloSerializers.HAMMER_RECIPE_SERIALIZER.get();
    }
}

