/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.crafting.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import novamachina.exnihilosequentia.common.crafting.ExNihiloRecipeSerializer;
import novamachina.exnihilosequentia.common.crafting.fluiditem.FluidItemRecipe;
import novamachina.exnihilosequentia.common.init.ExNihiloBlocks;
import novamachina.exnihilosequentia.common.utility.FluidStackUtils;

public class FluidItemRecipeSerializer
extends ExNihiloRecipeSerializer<FluidItemRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)ExNihiloBlocks.BARREL_OAK.get());
    }

    @Nonnull
    public FluidItemRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        FluidStack fluid = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
        Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        ItemStack output = buffer.m_130267_();
        return new FluidItemRecipe(recipeId, fluid, input, output);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull FluidItemRecipe recipe) {
        recipe.getFluidInBarrel().writeToPacket(buffer);
        recipe.getInput().m_43923_(buffer);
        buffer.m_130055_(recipe.m_8043_());
    }

    @Override
    @Nonnull
    protected FluidItemRecipe readFromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        FluidStack fluid = FluidStackUtils.jsonDeserializeFluidStack(json.get("fluid").getAsJsonObject());
        Ingredient input = Ingredient.m_43917_((JsonElement)json.get("input"));
        ItemStack result = this.readOutput(json.get("result"));
        return new FluidItemRecipe(recipeId, fluid, input, result);
    }
}

