/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.crafting.serializer;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import novamachina.exnihilosequentia.common.crafting.ExNihiloRecipeSerializer;
import novamachina.exnihilosequentia.common.crafting.fluidontop.FluidOnTopRecipe;
import novamachina.exnihilosequentia.common.init.ExNihiloBlocks;
import novamachina.exnihilosequentia.common.utility.FluidStackUtils;

public class FluidOnTopRecipeSerializer
extends ExNihiloRecipeSerializer<FluidOnTopRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)ExNihiloBlocks.BARREL_OAK.get());
    }

    @Nonnull
    public FluidOnTopRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        FluidStack fluidInTank = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
        FluidStack fluidOnTop = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
        ItemStack result = buffer.m_130267_();
        return new FluidOnTopRecipe(recipeId, fluidInTank, fluidOnTop, result);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull FluidOnTopRecipe recipe) {
        recipe.getFluidInTank().writeToPacket(buffer);
        recipe.getFluidOnTop().writeToPacket(buffer);
        buffer.m_130055_(recipe.m_8043_());
    }

    @Override
    @Nonnull
    protected FluidOnTopRecipe readFromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        FluidStack fluidInTank = FluidStackUtils.jsonDeserializeFluidStack(json.get("fluidInTank").getAsJsonObject());
        FluidStack fluidOnTop = FluidStackUtils.jsonDeserializeFluidStack(json.get("fluidOnTop").getAsJsonObject());
        ItemStack result = this.readOutput(json.get("result"));
        return new FluidOnTopRecipe(recipeId, fluidInTank, fluidOnTop, result);
    }
}

