/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.crafting.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import novamachina.exnihilosequentia.common.crafting.ExNihiloRecipeSerializer;
import novamachina.exnihilosequentia.common.crafting.fluidtransform.FluidTransformRecipe;
import novamachina.exnihilosequentia.common.init.ExNihiloBlocks;
import novamachina.exnihilosequentia.common.utility.FluidStackUtils;

public class FluidTransformRecipeSerializer
extends ExNihiloRecipeSerializer<FluidTransformRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)ExNihiloBlocks.BARREL_OAK.get());
    }

    @Nonnull
    public FluidTransformRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        FluidStack fluidInTank = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
        Ingredient catalyst = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        FluidStack result = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
        return new FluidTransformRecipe(recipeId, fluidInTank, catalyst, result);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull FluidTransformRecipe recipe) {
        recipe.getFluidInTank().writeToPacket(buffer);
        recipe.getCatalyst().m_43923_(buffer);
        recipe.getResult().writeToPacket(buffer);
    }

    @Override
    @Nonnull
    protected FluidTransformRecipe readFromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        FluidStack fluid = FluidStackUtils.jsonDeserializeFluidStack(json.get("fluidInTank").getAsJsonObject());
        Ingredient catalyst = Ingredient.m_43917_((JsonElement)json.get("catalyst"));
        FluidStack result = FluidStackUtils.jsonDeserializeFluidStack(json.get("result").getAsJsonObject());
        return new FluidTransformRecipe(recipeId, fluid, catalyst, result);
    }
}

