/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.item.ore;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import novamachina.exnihilosequentia.common.item.OreItem;
import novamachina.exnihilosequentia.common.network.HandshakeMessages;
import org.jetbrains.annotations.NotNull;

public class Ore {
    private static Map<String, Boolean> enabledMap = new HashMap<String, Boolean>();
    @Nonnull
    private final String name;
    @Nullable
    private Either<RegistryObject<OreItem>, Item> ingotItem;
    @Nullable
    private Either<RegistryObject<OreItem>, Item> rawOreItem;
    @Nullable
    private final RegistryObject<OreItem> pieceItem;
    @Nullable
    private Either<RegistryObject<OreItem>, Item> nuggetItem;

    public Ore(@Nonnull String name, boolean enabled, Optional<Item> optionalRawItem, Optional<Item> optionalIngotItem, Optional<Item> optionalNuggetItem, DeferredRegister<Item> registry) {
        this.name = name;
        enabledMap.put(name, enabled);
        this.ingotItem = optionalIngotItem.isEmpty() ? Either.left((Object)registry.register(this.getIngotName(), () -> new OreItem(this))) : Either.right((Object)optionalIngotItem.get());
        this.rawOreItem = optionalRawItem.isEmpty() ? Either.left((Object)registry.register(this.getRawOreName(), () -> new OreItem(this))) : Either.right((Object)optionalRawItem.get());
        this.pieceItem = registry.register(this.getPieceName(), () -> new OreItem(this));
        this.nuggetItem = optionalNuggetItem.isEmpty() ? Either.left((Object)registry.register(this.getNuggetName(), () -> new OreItem(this))) : Either.right((Object)optionalNuggetItem.get());
    }

    private String getNuggetName() {
        return String.format("%s_nugget", this.name);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean updateEnabledOres(@Nonnull HandshakeMessages.S2COreList message) {
        List<String> oreList = message.getOreList();
        enabledMap.replaceAll((k, v) -> false);
        if (oreList != null) {
            for (String ore : oreList) {
                enabledMap.put(ore, true);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public static List<String> getEnabledOres() {
        ArrayList<String> enabledOres = new ArrayList<String>();
        for (String key : enabledMap.keySet()) {
            if (!Boolean.TRUE.equals(enabledMap.get(key))) continue;
            enabledOres.add(key);
        }
        return enabledOres;
    }

    @Nullable
    public Either<RegistryObject<OreItem>, Item> getIngotItem() {
        return this.ingotItem;
    }

    @Nullable
    public Either<RegistryObject<OreItem>, Item> getNuggetItem() {
        return this.nuggetItem;
    }

    public String getIngotName() {
        return this.name + "_ingot";
    }

    @Nonnull
    public String getOreName() {
        return this.name;
    }

    @Nullable
    public OreItem getPieceItem() {
        return (OreItem)((Object)this.pieceItem.get());
    }

    public String getPieceName() {
        return this.name + "_pieces";
    }

    @Nullable
    public Either<RegistryObject<OreItem>, Item> getRawOreItem() {
        return this.rawOreItem;
    }

    public String getRawOreName() {
        return "raw_" + this.name;
    }

    public boolean isEnabled() {
        return enabledMap.getOrDefault(this.name, false);
    }

    public void setEnabled(boolean enabled) {
        enabledMap.put(this.name, enabled);
    }
}

