/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.loot.modifier;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.security.SecureRandom;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import novamachina.exnihilosequentia.api.tag.ExNihiloTags;
import novamachina.exnihilosequentia.common.block.InfestedLeavesBlock;
import novamachina.exnihilosequentia.common.crafting.ItemStackWithChance;
import novamachina.exnihilosequentia.common.crafting.crook.CrookRecipe;
import novamachina.exnihilosequentia.common.init.ExNihiloItems;
import novamachina.exnihilosequentia.common.registries.ExNihiloRegistries;
import novamachina.exnihilosequentia.common.utility.Config;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UseCrookModifier
extends LootModifier {
    public static final Supplier<Codec<UseCrookModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> UseCrookModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, UseCrookModifier::new)));
    @Nonnull
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogUtils.getLogger());
    @Nonnull
    private final Random random = new SecureRandom();

    public UseCrookModifier(@Nonnull LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    public ObjectArrayList<ItemStack> doApply(@Nonnull ObjectArrayList<ItemStack> generatedLoot, @Nonnull LootContext context) {
        logger.debug("Fired Crook Modifier");
        ItemStack tool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        BlockState blockState = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        Vec3 origin = (Vec3)context.m_78953_(LootContextParams.f_81460_);
        ObjectArrayList newLoot = new ObjectArrayList();
        if (tool != null && blockState != null && tool.m_41720_().m_7968_().m_204117_(ExNihiloTags.CROOK) && ExNihiloRegistries.CROOK_REGISTRY.isCrookable((ItemLike)blockState.m_60734_())) {
            for (int i = 0; i < Config.getVanillaSimulateDropCount(); ++i) {
                this.getVanillaDrops(context, blockState, origin, (List<ItemStack>)newLoot);
            }
            for (CrookRecipe recipe : ExNihiloRegistries.CROOK_REGISTRY.getDrops((ItemLike)blockState.m_60734_())) {
                this.getCrookBlockDrops((List<ItemStack>)newLoot, recipe);
            }
            if (blockState.m_60734_() instanceof InfestedLeavesBlock) {
                newLoot.add((Object)new ItemStack((ItemLike)Items.f_42401_, this.random.nextInt(Config.getMaxBonusStringCount()) + Config.getMinStringCount()));
                if (this.random.nextDouble() <= 0.8) {
                    newLoot.add((Object)new ItemStack((ItemLike)ExNihiloItems.SILKWORM.get()));
                }
            }
        }
        if (!newLoot.isEmpty()) {
            logger.debug("Adding new loot");
            generatedLoot = newLoot;
        }
        logger.debug("Crook Generated Loot: " + generatedLoot);
        return generatedLoot;
    }

    private void getCrookBlockDrops(@NotNull List<ItemStack> newLoot, @NotNull CrookRecipe recipe) {
        for (ItemStackWithChance itemStackWithChance : recipe.getOutput()) {
            if (!(this.random.nextFloat() <= itemStackWithChance.getChance()) || itemStackWithChance.getStack() == ItemStack.f_41583_) continue;
            newLoot.add(itemStackWithChance.getStack());
        }
    }

    private void getVanillaDrops(@NotNull LootContext context, @NotNull BlockState blockState, @Nullable Vec3 origin, @NotNull List<ItemStack> newLoot) {
        ServerLevel serverWorld = context.m_78952_().m_7654_().m_129880_(context.m_78952_().m_46472_());
        if (origin != null && serverWorld != null) {
            BlockPos pos = new BlockPos(origin.m_7096_(), origin.m_7098_(), origin.m_7094_());
            List items = Block.m_49869_((BlockState)blockState, (ServerLevel)serverWorld, (BlockPos)pos, null);
            newLoot.addAll(items.stream().filter(drop -> {
                ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((Object)drop.m_41720_());
                if (resourceLocation == null) {
                    return false;
                }
                return !resourceLocation.equals((Object)ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_()));
            }).toList());
        }
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

