/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.registries;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import novamachina.exnihilosequentia.common.crafting.compost.CompostRecipe;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;

public class CompostRegistry {
    @Nonnull
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogUtils.getLogger());
    @Nonnull
    public final List<CompostRecipe> recipeList = new ArrayList<CompostRecipe>();
    @Nonnull
    private final Map<Item, Integer> itemSolidAmountCache = new HashMap<Item, Integer>();

    public boolean containsSolid(@Nonnull ItemLike item) {
        return this.getSolidAmount(item) > 0;
    }

    public int getSolidAmount(@Nonnull ItemLike item) {
        return this.itemSolidAmountCache.computeIfAbsent(item.m_5456_(), k -> {
            ItemStack itemStack = new ItemStack(item);
            return this.recipeList.stream().filter(compostRecipe -> compostRecipe.getInput().test(itemStack)).findFirst().map(CompostRecipe::getAmount).orElse(0);
        });
    }

    public void setRecipes(@Nonnull List<CompostRecipe> recipes) {
        logger.debug("Compost Registry recipes: " + recipes.size());
        this.recipeList.addAll(recipes);
        this.itemSolidAmountCache.clear();
    }

    @Nonnull
    public List<CompostRecipe> getRecipeList() {
        return this.recipeList;
    }

    public void clearRecipes() {
        this.recipeList.clear();
        this.itemSolidAmountCache.clear();
    }
}

