/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.datagen.api.datagen;

import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraftforge.common.data.LanguageProvider;
import novamachina.exnihilosequentia.common.item.ore.Ore;
import novamachina.exnihilosequentia.common.utility.StringUtils;

public class AbstractLangGenerator
extends LanguageProvider {
    final String ITEM_LANG;

    public AbstractLangGenerator(DataGenerator gen, String modid, String locale) {
        super(gen, modid, locale);
        this.ITEM_LANG = "item." + modid + ".";
    }

    protected void addTranslations() {
    }

    protected String properNaming(String item) {
        return StringUtils.capitalize(item.replace("_", " "));
    }

    protected void addItem(String item, String name) {
        this.add(this.ITEM_LANG + item, name);
    }

    protected void addItemAutoName(String item) {
        this.add(this.ITEM_LANG + item, this.properNaming(item));
    }

    protected void addChunkAutoName(String item) {
        String CHUNK_LANG = this.ITEM_LANG + "raw_";
        this.add(CHUNK_LANG + item, this.properNaming("raw_" + item));
    }

    protected void addPieceAutoName(String item) {
        this.add(this.ITEM_LANG + item + "_pieces", this.properNaming(item + "_pieces"));
    }

    protected void addIngotAutoName(String item) {
        this.add(this.ITEM_LANG + item + "_ingot", this.properNaming(item + "_ingot"));
    }

    protected void addNuggetAutoName(String item) {
        this.add(this.ITEM_LANG + item + "_nugget", this.properNaming(item + "_nugget"));
    }

    protected void addMeshAutoName(String mesh) {
        if (Objects.equals(mesh, "none")) {
            return;
        }
        this.add(this.ITEM_LANG + mesh, this.properNaming(mesh));
    }

    protected void addFluid(String fluid, String name) {
        String FLUID_LANG = "fluid_type.exnihilosequentia.";
        this.add("fluid_type.exnihilosequentia." + fluid, name);
    }

    protected void addBlock(String block, String name) {
        String BLOCK_LANG = "block.exnihilosequentia.";
        this.add("block.exnihilosequentia." + block, name);
    }

    protected void addBlockAutoName(String block) {
        String BLOCK_LANG = "block.exnihilosequentia.";
        this.add("block.exnihilosequentia." + block, this.properNaming(block));
    }

    protected void addOreAutoName(Ore ore) {
        if (ore.getRawOreItem().left().isPresent()) {
            this.addChunkAutoName(ore.getOreName());
        }
        this.addPieceAutoName(ore.getOreName());
        if (ore.getIngotItem().left().isPresent()) {
            this.addIngotAutoName(ore.getOreName());
        }
        if (ore.getNuggetItem().left().isPresent()) {
            this.addNuggetAutoName(ore.getOreName());
        }
    }
}

