/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.datagen.api.datagen;

import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.ForgeRegistries;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;

public abstract class AbstractLootTableGenerator
implements DataProvider {
    @Nonnull
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    @Nonnull
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogUtils.getLogger());
    @Nonnull
    protected final Map<ResourceLocation, LootTable> lootTables = new HashMap<ResourceLocation, LootTable>();
    @Nonnull
    private final DataGenerator generator;
    @Nonnull
    private final String modId;

    protected AbstractLootTableGenerator(@Nonnull DataGenerator generator, @Nonnull String modId) {
        this.generator = generator;
        this.modId = modId;
    }

    public void m_213708_(@Nonnull CachedOutput cache) {
        this.lootTables.clear();
        Path outFolder = this.generator.m_123916_();
        this.createLootTables();
        ValidationContext validator = new ValidationContext(LootContextParamSets.f_81420_, function -> null, this.lootTables::get);
        this.lootTables.forEach((name, table) -> LootTables.m_79202_((ValidationContext)validator, (ResourceLocation)name, (LootTable)table));
        Multimap problems = validator.m_79352_();
        if (!problems.isEmpty()) {
            problems.forEach((name, table) -> logger.warn("Found validation problem in " + name + ": " + table));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        this.lootTables.forEach((name, table) -> {
            Path out = this.getPath(outFolder, (ResourceLocation)name);
            try {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)LootTables.m_79200_((LootTable)table), (Path)out);
            }
            catch (IOException e) {
                logger.error("Couldn't save loot table " + out);
                logger.error(Arrays.toString(e.getStackTrace()));
            }
        });
    }

    @Nonnull
    public String m_6055_() {
        return "Loot Tables: " + this.modId;
    }

    @Nonnull
    protected LootPool.Builder createLootPoolBuilder() {
        return LootPool.m_79043_().m_79080_(ExplosionCondition.m_81661_());
    }

    protected abstract void createLootTables();

    protected void register(@Nonnull Block block, LootPool.Builder ... pools) {
        LootTable.Builder builder = LootTable.m_79147_();
        for (LootPool.Builder pool : pools) {
            builder.m_79161_(pool);
        }
        this.register(block, builder);
    }

    protected void registerSelfDrop(@Nonnull Block block) {
        this.register(block, this.singleItem((ItemLike)block));
    }

    @Nonnull
    private Path getPath(@Nonnull Path outFolder, @Nonnull ResourceLocation name) {
        return outFolder.resolve("data/" + name.m_135827_() + "/loot_tables/" + name.m_135815_() + ".json");
    }

    private void register(@Nonnull Block block, @Nonnull LootTable.Builder table) {
        ResourceLocation resourceLocation = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (resourceLocation == null) {
            return;
        }
        this.register(resourceLocation, table);
    }

    private void register(@Nonnull ResourceLocation registryName, @Nonnull LootTable.Builder table) {
        if (this.lootTables.put(this.toTableLoc(registryName), table.m_79165_(LootContextParamSets.f_81421_).m_79167_()) != null) {
            throw new IllegalStateException("Duplicate loot table: " + table);
        }
    }

    @Nonnull
    private LootPool.Builder singleItem(@Nonnull ItemLike in) {
        return this.createLootPoolBuilder().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)in));
    }

    @Nonnull
    private ResourceLocation toTableLoc(@Nonnull ResourceLocation registryName) {
        return new ResourceLocation(registryName.m_135827_(), "blocks/" + registryName.m_135815_());
    }
}

