/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.datagen.api.datagen;

import com.mojang.datafixers.util.Either;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import novamachina.exnihilosequentia.common.item.OreItem;
import novamachina.exnihilosequentia.common.item.ore.Ore;

public abstract class AbstractOreItemGenerator
extends ItemModelProvider {
    private static final String ITEMS_TAG = "item/ore";
    private static final String ITEM_GENERATED_TAG = "item/generated";
    private static final String LAYER_0_TAG = "layer0";

    protected AbstractOreItemGenerator(@Nonnull DataGenerator generator, String modid, @Nonnull ExistingFileHelper existingFileHelper) {
        super(generator, modid, existingFileHelper);
    }

    protected void registerRaw(@Nonnull Ore ore) {
        Either<RegistryObject<OreItem>, Item> rawEither = ore.getRawOreItem();
        if (rawEither.left().isPresent()) {
            Item rawRegistryObject = (Item)((RegistryObject)rawEither.left().get()).get();
            ResourceLocation rawResourceLocation = ForgeRegistries.ITEMS.getKey((Object)rawRegistryObject);
            if (rawResourceLocation == null) {
                return;
            }
            this.singleTexture(rawResourceLocation.m_135815_(), new ResourceLocation(ITEM_GENERATED_TAG), LAYER_0_TAG, new ResourceLocation(this.modid, "item/ore/raw/" + rawResourceLocation.m_135815_()));
        }
    }

    protected void registerIngot(@Nonnull Ore ore) {
        Either<RegistryObject<OreItem>, Item> ingotEither = ore.getIngotItem();
        if (ingotEither.left().isPresent()) {
            Item ingotItem = (Item)((RegistryObject)ingotEither.left().get()).get();
            ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((Object)ingotItem);
            this.singleTexture(resourceLocation.m_135815_(), new ResourceLocation(ITEM_GENERATED_TAG), LAYER_0_TAG, new ResourceLocation(this.modid, "item/ore/ingot/" + resourceLocation.m_135815_()));
        }
    }

    protected void registerPiece(@Nonnull Ore ore) {
        OreItem pieceRegistryObject = ore.getPieceItem();
        if (pieceRegistryObject == null) {
            return;
        }
        ResourceLocation pieceResourceLocation = ForgeRegistries.ITEMS.getKey((Object)pieceRegistryObject);
        if (pieceResourceLocation == null) {
            return;
        }
        this.singleTexture(pieceResourceLocation.m_135815_(), new ResourceLocation(ITEM_GENERATED_TAG), LAYER_0_TAG, new ResourceLocation(this.modid, "item/ore/piece/" + pieceResourceLocation.m_135815_()));
    }

    protected void registerNugget(@Nonnull Ore ore) {
        Either<RegistryObject<OreItem>, Item> nuggetEither = ore.getNuggetItem();
        if (nuggetEither.left().isPresent()) {
            Item nuggetItem = (Item)((RegistryObject)nuggetEither.left().get()).get();
            ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((Object)nuggetItem);
            this.singleTexture(resourceLocation.m_135815_(), new ResourceLocation(ITEM_GENERATED_TAG), LAYER_0_TAG, new ResourceLocation(this.modid, "item/ore/nugget/" + resourceLocation.m_135815_()));
        }
    }

    @Nonnull
    private ResourceLocation exnihiloLoc(@Nonnull String path) {
        return new ResourceLocation("exnihilosequentia", path);
    }
}

