/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.datagen.client;

import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import novamachina.exnihilosequentia.common.init.ExNihiloItems;
import novamachina.exnihilosequentia.common.item.CrookBaseItem;
import novamachina.exnihilosequentia.common.item.HammerBaseItem;
import novamachina.exnihilosequentia.common.item.MeshItem;
import novamachina.exnihilosequentia.common.item.PebbleItem;
import novamachina.exnihilosequentia.common.item.ResourceItem;
import novamachina.exnihilosequentia.datagen.api.datagen.AbstractItemGenerator;

public class ExNihiloItemGenerator
extends AbstractItemGenerator {
    private static final String ITEMS_TAG = "item/";
    private static final String ITEM_HANDHELD_TAG = "item/handheld";
    private static final String ITEM_GENERATED_TAG = "item/generated";
    private static final String LAYER_0_TAG = "layer0";

    public ExNihiloItemGenerator(@Nonnull DataGenerator generator, @Nonnull ExistingFileHelper existingFileHelper) {
        super(generator, "exnihilosequentia", existingFileHelper);
    }

    private void registerCrook(CrookBaseItem crook) {
        ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((Object)crook);
        if (resourceLocation == null) {
            return;
        }
        this.singleTexture(resourceLocation.m_135815_(), new ResourceLocation(ITEM_HANDHELD_TAG), LAYER_0_TAG, new ResourceLocation(this.modid, "item/tools/crook/" + resourceLocation.m_135815_()));
    }

    private void registerCrooks() {
        for (RegistryObject<CrookBaseItem> crook : ExNihiloItems.CROOKS) {
            this.registerCrook((CrookBaseItem)((Object)crook.get()));
        }
    }

    private void registerDolls() {
        this.registerResource((ItemLike)ExNihiloItems.BEE_DOLL.get());
        this.registerResource((ItemLike)ExNihiloItems.ENDERMAN_DOLL.get());
        this.registerResource((ItemLike)ExNihiloItems.GUARDIAN_DOLL.get());
        this.registerResource((ItemLike)ExNihiloItems.SHULKER_DOLL.get());
        this.singleTexture(ForgeRegistries.ITEMS.getKey((Object)((Item)ExNihiloItems.BLAZE_DOLL.get())).m_135815_(), new ResourceLocation("exnihilosequentia:item/overlap_gui"), LAYER_0_TAG, new ResourceLocation(this.modid, ITEMS_TAG + ForgeRegistries.ITEMS.getKey((Object)((Item)ExNihiloItems.BLAZE_DOLL.get())).m_135815_()));
    }

    private void registerHammers() {
        for (RegistryObject<HammerBaseItem> hammer : ExNihiloItems.HAMMERS) {
            this.registerHammer((HammerBaseItem)((Object)hammer.get()));
        }
    }

    private void registerHammer(HammerBaseItem hammer) {
        ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((Object)hammer);
        if (resourceLocation == null) {
            return;
        }
        this.singleTexture(resourceLocation.m_135815_(), new ResourceLocation(ITEM_HANDHELD_TAG), LAYER_0_TAG, new ResourceLocation(this.modid, "item/tools/hammer/" + resourceLocation.m_135815_()));
    }

    private void registerMesh(MeshItem mesh) {
        ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((Object)mesh);
        if (resourceLocation == null) {
            return;
        }
        this.withExistingParent(resourceLocation.m_135815_(), new ResourceLocation(this.modid, "block/" + resourceLocation.m_135815_()));
    }

    private void registerMeshes() {
        this.registerMesh((MeshItem)((Object)ExNihiloItems.MESH_STRING.get()));
        this.registerMesh((MeshItem)((Object)ExNihiloItems.MESH_FLINT.get()));
        this.registerMesh((MeshItem)((Object)ExNihiloItems.MESH_IRON.get()));
        this.registerMesh((MeshItem)((Object)ExNihiloItems.MESH_DIAMOND.get()));
        this.registerMesh((MeshItem)((Object)ExNihiloItems.MESH_EMERALD.get()));
        this.registerMesh((MeshItem)((Object)ExNihiloItems.MESH_NETHERITE.get()));
    }

    protected void registerModels() {
        for (RegistryObject<ResourceItem> resourceItem : ExNihiloItems.RESOURCE_ITEMS) {
            this.registerResource((ItemLike)resourceItem.get());
        }
        this.registerResource((ItemLike)ExNihiloItems.SILKWORM.get());
        this.registerResource((ItemLike)ExNihiloItems.COOKED_SILKWORM.get());
        this.registerResource((ItemLike)ExNihiloItems.WITCH_WATER_BUCKET.get());
        this.registerResource((ItemLike)ExNihiloItems.SEA_WATER_BUCKET.get());
        this.registerResource((ItemLike)ExNihiloItems.END_CAKE.get());
        this.registerCrooks();
        this.registerHammers();
        this.registerSeeds();
        this.registerResources();
        this.registerPebbles();
        this.registerMeshes();
        this.registerDolls();
        this.registerNuggets();
    }

    private void registerNuggets() {
        for (RegistryObject<Item> nugget : ExNihiloItems.NUGGETS) {
            this.registerNugget((ItemLike)nugget.get());
        }
    }

    private void registerResource(ItemLike item) {
        ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((Object)item.m_5456_());
        if (resourceLocation == null) {
            return;
        }
        this.singleTexture(resourceLocation.m_135815_(), new ResourceLocation(ITEM_GENERATED_TAG), LAYER_0_TAG, new ResourceLocation(this.modid, ITEMS_TAG + resourceLocation.m_135815_()));
    }

    private void registerNugget(ItemLike item) {
        ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((Object)item.m_5456_());
        if (resourceLocation == null) {
            return;
        }
        this.singleTexture(resourceLocation.m_135815_(), new ResourceLocation(ITEM_GENERATED_TAG), LAYER_0_TAG, new ResourceLocation(this.modid, "item/ore/nugget/" + resourceLocation.m_135815_()));
    }

    private void registerPebbles() {
        for (RegistryObject<PebbleItem> pebble : ExNihiloItems.PEBBLES) {
            this.registerResource((ItemLike)pebble.get());
        }
    }

    private void registerResources() {
        this.registerResource((ItemLike)ExNihiloItems.MYCELIUM_SPORE.get());
        this.registerResource((ItemLike)ExNihiloItems.CRIMSON_NYLIUM_SPORE.get());
        this.registerResource((ItemLike)ExNihiloItems.WARPED_NYLIUM_SPORE.get());
        this.registerResource((ItemLike)ExNihiloItems.GRASS_SEED.get());
        this.registerResource((ItemLike)ExNihiloItems.PORCELAIN_CLAY.get());
        this.registerResource((ItemLike)ExNihiloItems.CRAFTING_DOLL.get());
        this.registerResource((ItemLike)ExNihiloItems.TUBE_CORAL_LARVA.get());
        this.registerResource((ItemLike)ExNihiloItems.BRAIN_CORAL_LARVA.get());
        this.registerResource((ItemLike)ExNihiloItems.BUBBLE_CORAL_LARVA.get());
        this.registerResource((ItemLike)ExNihiloItems.FIRE_CORAL_LARVA.get());
        this.registerResource((ItemLike)ExNihiloItems.HORN_CORAL_LARVA.get());
        this.registerResource((ItemLike)ExNihiloItems.BEEHIVE_FRAME.get());
    }

    private void registerSeeds() {
    }
}

