/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.common.items;

import appeng.api.config.FuzzyMode;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.core.AEConfig;
import appeng.items.AEBaseItem;
import appeng.items.storage.StorageCellTooltipComponent;
import com.github.glodblock.epp.common.EPPItemAndBlock;
import com.github.glodblock.epp.config.EPPConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public class InfinityCell
extends AEBaseItem
implements ICellWorkbenchItem {
    public InfinityCell() {
        super(new Item.Properties().m_41487_(1).m_41491_(EPPItemAndBlock.TAB));
    }

    @NotNull
    public AEKey getRecord(ItemStack stack) {
        AEKey key;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && (key = AEKey.fromTagGeneric((CompoundTag)tag.m_128469_("record"))) != null) {
            return key;
        }
        return AEFluidKey.of((Fluid)Fluids.f_76193_);
    }

    public ItemStack getRecordCell(AEKey record) {
        ItemStack stack = new ItemStack((ItemLike)EPPItemAndBlock.INFINITY_CELL);
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("record", (Tag)record.toTagGeneric());
        stack.m_41751_(tag);
        return stack;
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack is) {
        return Component.m_237110_((String)"item.expatternprovider.infinity_cell_name", (Object[])new Object[]{this.getRecord(is).getDisplayName()});
    }

    public void m_6787_(@NotNull CreativeModeTab group, @NotNull NonNullList<ItemStack> items) {
        if (this.m_220152_(group)) {
            EPPConfig.infCellFluid.forEach(f -> items.add((Object)this.getRecordCell((AEKey)AEFluidKey.of((Fluid)f))));
            EPPConfig.infCellItem.forEach(i -> items.add((Object)this.getRecordCell((AEKey)AEItemKey.of((ItemLike)i))));
        }
    }

    public void m_7373_(@NotNull ItemStack is, Level world, @NotNull List<Component> lines, @NotNull TooltipFlag adv) {
        lines.add((Component)Component.m_237115_((String)"infinity.tooltip").m_130940_(ChatFormatting.GREEN));
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack stack) {
        ArrayList<ItemStack> upgrades = new ArrayList<ItemStack>();
        if (AEConfig.instance().isTooltipShowCellUpgrades()) {
            for (ItemStack upgrade : this.getUpgrades(stack)) {
                upgrades.add(upgrade);
            }
        }
        List<GenericStack> content = Collections.singletonList(new GenericStack(this.getRecord(stack), InfinityCell.getAsIntMax(this.getRecord(stack))));
        return Optional.of(new StorageCellTooltipComponent(upgrades, content, false));
    }

    public IUpgradeInventory getUpgrades(ItemStack is) {
        return UpgradeInventories.forItem((ItemStack)is, (int)1);
    }

    public FuzzyMode getFuzzyMode(ItemStack itemStack) {
        return FuzzyMode.IGNORE_ALL;
    }

    public void setFuzzyMode(ItemStack itemStack, FuzzyMode fuzzyMode) {
    }

    public static long getAsIntMax(AEKey key) {
        if (key instanceof AEFluidKey) {
            return 2147483647000L;
        }
        return Integer.MAX_VALUE;
    }
}

