/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.block;

import com.blakebr0.cucumber.block.BaseTileEntityBlock;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.iface.IEnableable;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.util.VoxelShapeBuilder;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.tileentity.PedestalTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PedestalBlock
extends BaseTileEntityBlock
implements IEnableable {
    public static final VoxelShape PEDESTAL_SHAPE = new VoxelShapeBuilder().cuboid(3.0, 2.0, 3.0, 13.0, 14.0, 13.0).cuboid(1.0, 0.0, 1.0, 15.0, 2.0, 15.0).cuboid(2.0, 14.0, 2.0, 14.0, 16.0, 14.0).build();

    public PedestalBlock() {
        super(Material.f_76279_, SoundType.f_56743_, 5.0f, 10.0f, true);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PedestalTileEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult trace) {
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof PedestalTileEntity) {
            PedestalTileEntity pedestal = (PedestalTileEntity)tile;
            BaseItemStackHandler inventory = pedestal.getInventory();
            ItemStack input = inventory.getStackInSlot(0);
            ItemStack held = player.m_21120_(hand);
            if (input.m_41619_() && !held.m_41619_()) {
                inventory.setStackInSlot(0, StackHelper.withSize((ItemStack)held, (int)1, (boolean)false));
                player.m_21008_(hand, StackHelper.shrink((ItemStack)held, (int)1, (boolean)false));
                level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (!input.m_41619_()) {
                ItemEntity item = new ItemEntity(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), input);
                item.m_32061_();
                level.m_7967_((Entity)item);
                inventory.setStackInSlot(0, ItemStack.f_41583_);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile;
        if (state.m_60734_() != newState.m_60734_() && (tile = level.m_7702_(pos)) instanceof PedestalTileEntity) {
            PedestalTileEntity pedestal = (PedestalTileEntity)tile;
            Containers.m_19010_((Level)level, (BlockPos)pos, (NonNullList)pedestal.getInventory().getStacks());
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return PEDESTAL_SHAPE;
    }

    public boolean isEnabled() {
        return (Boolean)ModConfigs.ENABLE_CRAFTING_CORE.get();
    }
}

