/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.crafttweaker;

import com.blakebr0.cucumber.helper.RecipeHelper;
import com.blakebr0.extendedcrafting.crafting.recipe.CompressorRecipe;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.base.IRuntimeAction;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.extendedcrafting.CompressionCrafting")
@ZenRegister
public final class CompressionCrafting {
    @ZenCodeType.Method
    public static void addRecipe(final String id, final IIngredient input, final IItemStack output, final int inputCount, final IIngredient catalyst, final int powerCost) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                CompressorRecipe recipe = new CompressorRecipe(new ResourceLocation("crafttweaker", id), input.asVanillaIngredient(), output.getInternal(), inputCount, catalyst.asVanillaIngredient(), powerCost);
                RecipeHelper.addRecipe((Recipe)recipe);
            }

            public String describe() {
                return "Adding Compression Crafting recipe for " + output.getCommandString();
            }
        });
    }

    @ZenCodeType.Method
    public static void addRecipe(final String id, final IIngredient input, final IItemStack output, final int inputCount, final IIngredient catalyst, final int powerCost, final int powerRate) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                CompressorRecipe recipe = new CompressorRecipe(new ResourceLocation("crafttweaker", id), input.asVanillaIngredient(), output.getInternal(), inputCount, catalyst.asVanillaIngredient(), powerCost, powerRate);
                RecipeHelper.addRecipe((Recipe)recipe);
            }

            public String describe() {
                return "Adding Compression Crafting recipe for " + output.getCommandString();
            }
        });
    }

    @ZenCodeType.Method
    public static void remove(final IItemStack stack) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                List<ResourceLocation> recipes = ((Map)RecipeHelper.getRecipes().getOrDefault(ModRecipeTypes.COMPRESSOR.get(), new HashMap())).values().stream().filter(r -> r.m_8043_().m_41656_(stack.getInternal())).map(Recipe::m_6423_).toList();
                recipes.forEach(r -> ((Map)RecipeHelper.getRecipes().get(ModRecipeTypes.COMPRESSOR.get())).remove(r));
            }

            public String describe() {
                return "Removing Compression Crafting recipes for " + stack.getCommandString();
            }
        });
    }
}

