/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.crafttweaker;

import com.blakebr0.cucumber.helper.RecipeHelper;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapedEnderCrafterRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapelessEnderCrafterRecipe;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.base.IRuntimeAction;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.extendedcrafting.EnderCrafting")
@ZenRegister
public final class EnderCrafting {
    @ZenCodeType.Method
    public static void addShaped(String id, IItemStack output, IIngredient[][] inputs) {
        EnderCrafting.addShaped(id, output, inputs, (Integer)ModConfigs.ENDER_CRAFTER_TIME_REQUIRED.get());
    }

    @ZenCodeType.Method
    public static void addShaped(final String id, final IItemStack output, final IIngredient[][] inputs, final int time) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                int height = inputs.length;
                int width = 0;
                for (IIngredient[] row : inputs) {
                    if (width >= row.length) continue;
                    width = row.length;
                }
                NonNullList ingredients = NonNullList.m_122780_((int)(height * width), (Object)Ingredient.f_43901_);
                for (int a = 0; a < height; ++a) {
                    for (int b = 0; b < inputs[a].length; ++b) {
                        Ingredient ing = inputs[a][b].asVanillaIngredient();
                        int i = a * width + b;
                        ingredients.set(i, (Object)ing);
                    }
                }
                ShapedEnderCrafterRecipe recipe = new ShapedEnderCrafterRecipe(new ResourceLocation("crafttweaker", id), width, height, (NonNullList<Ingredient>)ingredients, output.getInternal(), time);
                RecipeHelper.addRecipe((Recipe)recipe);
            }

            public String describe() {
                return "Adding Shaped Ender Crafting recipe for " + output.getCommandString();
            }
        });
    }

    @ZenCodeType.Method
    public static void addShapeless(String id, IItemStack output, IIngredient[] inputs) {
        EnderCrafting.addShapeless(id, output, inputs, (Integer)ModConfigs.ENDER_CRAFTER_TIME_REQUIRED.get());
    }

    @ZenCodeType.Method
    public static void addShapeless(final String id, final IItemStack output, final IIngredient[] inputs, final int time) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                ShapelessEnderCrafterRecipe recipe = new ShapelessEnderCrafterRecipe(new ResourceLocation("crafttweaker", id), EnderCrafting.toIngredientsList(inputs), output.getInternal(), time);
                RecipeHelper.addRecipe((Recipe)recipe);
            }

            public String describe() {
                return "Adding Shapeless Ender Crafter recipe for " + output.getCommandString();
            }
        });
    }

    @ZenCodeType.Method
    public static void remove(final IItemStack stack) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                List<ResourceLocation> recipes = ((Map)RecipeHelper.getRecipes().getOrDefault(ModRecipeTypes.ENDER_CRAFTER.get(), new HashMap())).values().stream().filter(r -> r.m_8043_().m_41656_(stack.getInternal())).map(Recipe::m_6423_).toList();
                recipes.forEach(r -> ((Map)RecipeHelper.getRecipes().get(ModRecipeTypes.ENDER_CRAFTER.get())).remove(r));
            }

            public String describe() {
                return "Removing Ender Crafter recipes for " + stack.getCommandString();
            }
        });
    }

    private static NonNullList<Ingredient> toIngredientsList(IIngredient ... ingredients) {
        return Arrays.stream(ingredients).map(IIngredient::asVanillaIngredient).collect(Collectors.toCollection(NonNullList::m_122779_));
    }
}

