/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.crafttweaker;

import com.blakebr0.cucumber.helper.RecipeHelper;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapedFluxCrafterRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapelessFluxCrafterRecipe;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.base.IRuntimeAction;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.extendedcrafting.FluxCrafting")
@ZenRegister
public final class FluxCrafting {
    @ZenCodeType.Method
    public static void addShaped(String id, IItemStack output, IIngredient[][] inputs, int powerRequired) {
        FluxCrafting.addShaped(id, output, inputs, powerRequired, (Integer)ModConfigs.FLUX_CRAFTER_POWER_RATE.get());
    }

    @ZenCodeType.Method
    public static void addShaped(final String id, final IItemStack output, final IIngredient[][] inputs, final int powerRequired, final int powerRate) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                int height = inputs.length;
                int width = 0;
                for (IIngredient[] row : inputs) {
                    if (width >= row.length) continue;
                    width = row.length;
                }
                NonNullList ingredients = NonNullList.m_122780_((int)(height * width), (Object)Ingredient.f_43901_);
                for (int a = 0; a < height; ++a) {
                    for (int b = 0; b < inputs[a].length; ++b) {
                        Ingredient ing = inputs[a][b].asVanillaIngredient();
                        int i = a * width + b;
                        ingredients.set(i, (Object)ing);
                    }
                }
                ShapedFluxCrafterRecipe recipe = new ShapedFluxCrafterRecipe(new ResourceLocation("crafttweaker", id), width, height, (NonNullList<Ingredient>)ingredients, output.getInternal(), powerRequired, powerRate);
                RecipeHelper.addRecipe((Recipe)recipe);
            }

            public String describe() {
                return "Adding Shaped Flux Crafting recipe for " + output.getCommandString();
            }
        });
    }

    @ZenCodeType.Method
    public static void addShapeless(String id, IItemStack output, IIngredient[] inputs, int powerRequired) {
        FluxCrafting.addShapeless(id, output, inputs, powerRequired, (Integer)ModConfigs.FLUX_CRAFTER_POWER_RATE.get());
    }

    @ZenCodeType.Method
    public static void addShapeless(final String id, final IItemStack output, final IIngredient[] inputs, final int powerRequired, final int powerRate) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                ShapelessFluxCrafterRecipe recipe = new ShapelessFluxCrafterRecipe(new ResourceLocation("crafttweaker", id), FluxCrafting.toIngredientsList(inputs), output.getInternal(), powerRequired, powerRate);
                RecipeHelper.addRecipe((Recipe)recipe);
            }

            public String describe() {
                return "Adding Shapeless Flux Crafter recipe for " + output.getCommandString();
            }
        });
    }

    @ZenCodeType.Method
    public static void remove(final IItemStack stack) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                List<ResourceLocation> recipes = ((Map)RecipeHelper.getRecipes().getOrDefault(ModRecipeTypes.FLUX_CRAFTER.get(), new HashMap())).values().stream().filter(r -> r.m_8043_().m_41656_(stack.getInternal())).map(Recipe::m_6423_).toList();
                recipes.forEach(r -> ((Map)RecipeHelper.getRecipes().get(ModRecipeTypes.FLUX_CRAFTER.get())).remove(r));
            }

            public String describe() {
                return "Removing Flux Crafter recipes for " + stack.getCommandString();
            }
        });
    }

    private static NonNullList<Ingredient> toIngredientsList(IIngredient ... ingredients) {
        return Arrays.stream(ingredients).map(IIngredient::asVanillaIngredient).collect(Collectors.toCollection(NonNullList::m_122779_));
    }
}

