/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.crafttweaker;

import com.blakebr0.cucumber.helper.RecipeHelper;
import com.blakebr0.cucumber.util.TriFunction;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapedTableRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapelessTableRecipe;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.base.IRuntimeAction;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.extendedcrafting.TableCrafting")
@ZenRegister
public final class TableCrafting {
    @ZenCodeType.Method
    public static void addShaped(String id, IItemStack output, IIngredient[][] inputs) {
        TableCrafting.addShaped(id, 0, output, inputs);
    }

    @ZenCodeType.Method
    public static void addShaped(final String id, final int tier, final IItemStack output, final IIngredient[][] inputs) {
        if (tier > 4 || tier < 0) {
            CraftTweakerAPI.LOGGER.error("Unable to assign a tier to the Table Recipe for stack " + output.getCommandString() + ". Tier cannot be greater than 4 or less than 0.");
        }
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                int height = inputs.length;
                int width = 0;
                for (IIngredient[] row : inputs) {
                    if (width >= row.length) continue;
                    width = row.length;
                }
                NonNullList ingredients = NonNullList.m_122780_((int)(height * width), (Object)Ingredient.f_43901_);
                for (int a = 0; a < height; ++a) {
                    for (int b = 0; b < inputs[a].length; ++b) {
                        IIngredient iing = inputs[a][b];
                        Ingredient ing = iing.asVanillaIngredient();
                        int i = a * width + b;
                        ingredients.set(i, (Object)ing);
                    }
                }
                ShapedTableRecipe recipe = new ShapedTableRecipe(new ResourceLocation("crafttweaker", id), width, height, (NonNullList<Ingredient>)ingredients, output.getInternal(), TableCrafting.clampTier(tier));
                recipe.setTransformer((TriFunction<Integer, Integer, ItemStack, ItemStack>)((TriFunction)(x, y, stack) -> inputs[y][x].getRemainingItem((IItemStack)new MCItemStack(stack)).getInternal()));
                RecipeHelper.addRecipe((Recipe)recipe);
            }

            public String describe() {
                return "Adding Shaped Table recipe for " + output.getCommandString();
            }
        });
    }

    @ZenCodeType.Method
    public static void addShapeless(String id, IItemStack output, IIngredient[] inputs) {
        TableCrafting.addShapeless(id, 0, output, inputs);
    }

    @ZenCodeType.Method
    public static void addShapeless(final String id, final int tier, final IItemStack output, final IIngredient[] inputs) {
        if (tier > 4 || tier < 0) {
            CraftTweakerAPI.LOGGER.error("Unable to assign a tier to the Table Recipe for stack " + output.getCommandString() + ". Tier cannot be greater than 4 or less than 0.");
        }
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                ShapelessTableRecipe recipe = new ShapelessTableRecipe(new ResourceLocation("crafttweaker", id), TableCrafting.toIngredientsList(inputs), output.getInternal(), TableCrafting.clampTier(tier));
                recipe.setTransformer((slot, stack) -> inputs[slot].getRemainingItem((IItemStack)new MCItemStack(stack)).getInternal());
                RecipeHelper.addRecipe((Recipe)recipe);
            }

            public String describe() {
                return "Adding Shapeless Table Crafting recipe for " + output.getCommandString();
            }
        });
    }

    @ZenCodeType.Method
    public static void remove(final IItemStack stack) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                List<ResourceLocation> recipes = ((Map)RecipeHelper.getRecipes().getOrDefault(ModRecipeTypes.TABLE.get(), new HashMap())).values().stream().filter(r -> r.m_8043_().m_41656_(stack.getInternal())).map(Recipe::m_6423_).toList();
                recipes.forEach(r -> ((Map)RecipeHelper.getRecipes().get(ModRecipeTypes.TABLE.get())).remove(r));
            }

            public String describe() {
                return "Removing Table Crafting recipes for " + stack.getCommandString();
            }
        });
    }

    private static NonNullList<Ingredient> toIngredientsList(IIngredient ... ingredients) {
        return Arrays.stream(ingredients).map(IIngredient::asVanillaIngredient).collect(Collectors.toCollection(NonNullList::m_122779_));
    }

    private static int clampTier(int tier) {
        return tier > 4 || tier < 0 ? 0 : tier;
    }
}

