/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.jei.category;

import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.extendedcrafting.api.crafting.IFluxCrafterRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapedFluxCrafterRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapelessFluxCrafterRecipe;
import com.blakebr0.extendedcrafting.init.ModBlocks;
import com.blakebr0.extendedcrafting.lib.ModTooltips;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class FluxCraftingCategory
implements IRecipeCategory<IFluxCrafterRecipe> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("extendedcrafting", "textures/gui/jei/flux_crafting.png");
    public static final RecipeType<IFluxCrafterRecipe> RECIPE_TYPE = RecipeType.create((String)"extendedcrafting", (String)"flux_crafting", IFluxCrafterRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public FluxCraftingCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 149, 78);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.FLUX_CRAFTER.get()));
    }

    public RecipeType<IFluxCrafterRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Localizable.of((String)"jei.category.extendedcrafting.flux_crafting").build();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public List<Component> getTooltipStrings(IFluxCrafterRecipe recipe, IRecipeSlotsView slots, double mouseX, double mouseY) {
        if (mouseX > 1.0 && mouseX < 14.0 && mouseY > 1.0 && mouseY < 78.0) {
            return List.of(Component.m_237113_((String)(Utils.format((Object)recipe.getPowerRequired()) + " FE")), ModTooltips.PER_ALTERNATOR.args(new Object[]{Utils.format((Object)recipe.getPowerRate()) + " FE/t"}).color(ChatFormatting.WHITE).build());
        }
        return List.of();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IFluxCrafterRecipe recipe, IFocusGroup focuses) {
        NonNullList inputs = recipe.m_7527_();
        ItemStack output = recipe.m_8043_();
        if (recipe instanceof ShapedFluxCrafterRecipe) {
            ShapedFluxCrafterRecipe shaped = (ShapedFluxCrafterRecipe)recipe;
            int stackIndex = 0;
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.INPUT, j * 18 + 26, i * 18 + 13);
                    if (i >= shaped.getHeight() || j >= shaped.getWidth()) continue;
                    slot.addIngredients((Ingredient)inputs.get(stackIndex++));
                }
            }
        } else if (recipe instanceof ShapelessFluxCrafterRecipe) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int index = j + i * 3;
                    if (index >= inputs.size()) continue;
                    builder.addSlot(RecipeIngredientRole.INPUT, j * 18 + 26, i * 18 + 13).addIngredients((Ingredient)inputs.get(index));
                }
            }
            builder.setShapeless();
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 120, 31).addItemStack(output);
        builder.moveRecipeTransferButton(134, 63);
    }
}

