/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.container;

import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.extendedcrafting.api.crafting.ITableRecipe;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.container.inventory.ExtendedCraftingInventory;
import com.blakebr0.extendedcrafting.container.slot.AutoTableOutputSlot;
import com.blakebr0.extendedcrafting.container.slot.TableOutputSlot;
import com.blakebr0.extendedcrafting.init.ModContainerTypes;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.blakebr0.extendedcrafting.tileentity.AutoTableTileEntity;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;

public class BasicAutoTableContainer
extends AbstractContainerMenu {
    private final Function<Player, Boolean> isUsableByPlayer;
    private final ContainerData data;
    private final BlockPos pos;
    private final Level world;
    private final Container result;
    private boolean isVanillaRecipe = false;

    private BasicAutoTableContainer(MenuType<?> type, int id, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(type, id, playerInventory, p -> false, AutoTableTileEntity.Basic.createInventoryHandler(null), (ContainerData)new SimpleContainerData(6), buffer.m_130135_());
    }

    private BasicAutoTableContainer(MenuType<?> type, int id, Inventory playerInventory, Function<Player, Boolean> isUsableByPlayer, BaseItemStackHandler inventory, ContainerData data, BlockPos pos) {
        super(type, id);
        int j;
        int i;
        this.isUsableByPlayer = isUsableByPlayer;
        this.data = data;
        this.pos = pos;
        this.world = playerInventory.f_35978_.f_19853_;
        this.result = new ResultContainer();
        ExtendedCraftingInventory matrix = new ExtendedCraftingInventory(this, inventory, 3, true);
        this.m_38897_(new TableOutputSlot(this, (Container)matrix, this.result, 0, 129, 34));
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.m_38897_(new Slot((Container)matrix, j + i * 3, 33 + j * 18, 30 + i * 18));
            }
        }
        this.m_38897_((Slot)new AutoTableOutputSlot(this, matrix, (IItemHandler)inventory, 9, 129, 78));
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 112 + i * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.m_38897_(new Slot((Container)playerInventory, j, 8 + j * 18, 170));
        }
        this.m_6199_((Container)matrix);
        this.m_38884_(data);
    }

    public void m_6199_(Container matrix) {
        Optional recipe = this.world.m_7465_().m_44015_((RecipeType)ModRecipeTypes.TABLE.get(), matrix, this.world);
        this.isVanillaRecipe = false;
        if (recipe.isPresent()) {
            ItemStack result = ((ITableRecipe)recipe.get()).m_5874_(matrix);
            this.result.m_6836_(0, result);
        } else if (((Boolean)ModConfigs.TABLE_USE_VANILLA_RECIPES.get()).booleanValue()) {
            Optional vanilla = this.world.m_7465_().m_44015_(RecipeType.f_44107_, (Container)((CraftingContainer)matrix), this.world);
            if (vanilla.isPresent()) {
                ItemStack result = ((CraftingRecipe)vanilla.get()).m_5874_((Container)((CraftingContainer)matrix));
                this.isVanillaRecipe = true;
                this.result.m_6836_(0, result);
            } else {
                this.result.m_6836_(0, ItemStack.f_41583_);
            }
        } else {
            this.result.m_6836_(0, ItemStack.f_41583_);
        }
        super.m_6199_(matrix);
    }

    public boolean m_6875_(Player player) {
        return this.isUsableByPlayer.apply(player);
    }

    public ItemStack m_7648_(Player player, int slotNumber) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotNumber);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (slotNumber == 0 || slotNumber == 10) {
                if (!this.m_38903_(itemstack1, 11, 47, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (slotNumber >= 11 && slotNumber < 47 ? !this.m_38903_(itemstack1, 1, 10, false) : !this.m_38903_(itemstack1, 11, 47, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public boolean isVanillaRecipe() {
        return this.isVanillaRecipe;
    }

    public static BasicAutoTableContainer create(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new BasicAutoTableContainer((MenuType)ModContainerTypes.BASIC_AUTO_TABLE.get(), windowId, playerInventory, buffer);
    }

    public static BasicAutoTableContainer create(int windowId, Inventory playerInventory, Function<Player, Boolean> isUsableByPlayer, BaseItemStackHandler inventory, ContainerData data, BlockPos pos) {
        return new BasicAutoTableContainer((MenuType)ModContainerTypes.BASIC_AUTO_TABLE.get(), windowId, playerInventory, isUsableByPlayer, inventory, data, pos);
    }
}

