/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting;

import com.blakebr0.cucumber.event.RecipeManagerLoadingEvent;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.crafting.recipe.CompressorRecipe;
import com.blakebr0.extendedcrafting.singularity.Singularity;
import com.blakebr0.extendedcrafting.singularity.SingularityRegistry;
import com.blakebr0.extendedcrafting.singularity.SingularityUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public final class DynamicRecipeManager {
    private static final DynamicRecipeManager INSTANCE = new DynamicRecipeManager();

    @SubscribeEvent
    public void onRecipeManagerLoading(RecipeManagerLoadingEvent event) {
        SingularityRegistry.getInstance().loadSingularities();
        for (Singularity singularity : SingularityRegistry.getInstance().getSingularities()) {
            CompressorRecipe compressorRecipe = DynamicRecipeManager.makeSingularityRecipe(singularity);
            if (compressorRecipe == null) continue;
            event.addRecipe((Recipe)compressorRecipe);
        }
    }

    public static DynamicRecipeManager getInstance() {
        return INSTANCE;
    }

    private static CompressorRecipe makeSingularityRecipe(Singularity singularity) {
        if (!((Boolean)ModConfigs.SINGULARITY_DEFAULT_RECIPES.get()).booleanValue()) {
            return null;
        }
        Ingredient ingredient = singularity.getIngredient();
        if (ingredient == Ingredient.f_43901_) {
            return null;
        }
        ResourceLocation id = singularity.getId();
        ResourceLocation recipeId = new ResourceLocation("extendedcrafting", id.m_135815_() + "_singularity");
        ItemStack output = SingularityUtils.getItemForSingularity(singularity);
        int ingredientCount = singularity.getIngredientCount();
        String catalystId = (String)ModConfigs.SINGULARITY_DEFAULT_CATALYST.get();
        Item catalystItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(catalystId));
        Ingredient catalyst = Ingredient.m_43929_((ItemLike[])new ItemLike[]{catalystItem});
        int powerRequired = (Integer)ModConfigs.SINGULARITY_POWER_REQUIRED.get();
        return new CompressorRecipe(recipeId, ingredient, output, ingredientCount, catalyst, powerRequired);
    }
}

