/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.handler;

import com.blakebr0.cucumber.helper.ColorHelper;
import com.blakebr0.cucumber.iface.IColored;
import com.blakebr0.extendedcrafting.init.ModBlocks;
import com.blakebr0.extendedcrafting.init.ModItems;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class ColorHandler {
    @SubscribeEvent
    public void onBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((state, level, pos, index) -> ColorHandler.getCurrentRainbowColor(), new Block[]{(Block)ModBlocks.THE_ULTIMATE_BLOCK.get()});
    }

    @SubscribeEvent
    public void onItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((ItemColor)new IColored.ItemColors(), new ItemLike[]{(ItemLike)ModItems.SINGULARITY.get()});
        event.register((stack, index) -> ColorHandler.getCurrentRainbowColor(), new ItemLike[]{(ItemLike)ModBlocks.THE_ULTIMATE_BLOCK.get(), (ItemLike)ModItems.ULTIMATE_SINGULARITY.get(), (ItemLike)ModItems.THE_ULTIMATE_INGOT.get(), (ItemLike)ModItems.THE_ULTIMATE_NUGGET.get()});
        event.register((stack, index) -> index == 1 ? ColorHandler.getCurrentRainbowColor() : -1, new ItemLike[]{(ItemLike)ModItems.THE_ULTIMATE_COMPONENT.get(), (ItemLike)ModItems.THE_ULTIMATE_CATALYST.get()});
    }

    public static int getCurrentRainbowColor() {
        float hue = (float)(System.currentTimeMillis() % 18000L) / 18000.0f;
        return ColorHelper.hsbToRGB((float)hue, (float)1.0f, (float)1.0f);
    }
}

