/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.tileentity;

import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.container.CompressorContainer;
import com.blakebr0.extendedcrafting.crafting.recipe.CompressorRecipe;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.blakebr0.extendedcrafting.init.ModTileEntities;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;

public class CompressorTileEntity
extends BaseInventoryTileEntity
implements MenuProvider {
    private final BaseItemStackHandler inventory;
    private final BaseItemStackHandler recipeInventory;
    private final EnergyStorage energy;
    private final LazyOptional<IEnergyStorage> capability = LazyOptional.of(this::getEnergy);
    private CompressorRecipe recipe;
    private ItemStack materialStack = ItemStack.f_41583_;
    private List<MaterialInput> inputs = NonNullList.m_122779_();
    private int materialCount;
    private int progress;
    private boolean ejecting = false;
    private int oldEnergy;
    private boolean inputLimit = true;

    public CompressorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.COMPRESSOR.get(), pos, state);
        this.inventory = CompressorTileEntity.createInventoryHandler(null);
        this.recipeInventory = new BaseItemStackHandler(2);
        this.energy = new EnergyStorage(((Integer)ModConfigs.COMPRESSOR_POWER_CAPACITY.get()).intValue());
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.materialCount = tag.m_128451_("MaterialCount");
        this.materialStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("MaterialStack"));
        this.progress = tag.m_128451_("Progress");
        this.ejecting = tag.m_128471_("Ejecting");
        this.energy.deserializeNBT(tag.m_128423_("Energy"));
        this.inputLimit = tag.m_128471_("InputLimit");
        this.inputs = CompressorTileEntity.loadMaterialInputs(tag);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("MaterialCount", this.materialCount);
        tag.m_128365_("MaterialStack", (Tag)this.materialStack.serializeNBT());
        tag.m_128405_("Progress", this.progress);
        tag.m_128379_("Ejecting", this.ejecting);
        tag.m_128405_("Energy", this.energy.getEnergyStored());
        tag.m_128379_("InputLimit", this.inputLimit);
        CompressorTileEntity.saveMaterialInputs(tag, this.inputs);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.m_58901_() && cap == CapabilityEnergy.ENERGY) {
            return CapabilityEnergy.ENERGY.orEmpty(cap, this.capability);
        }
        return super.getCapability(cap, side);
    }

    public Component m_5446_() {
        return Localizable.of((String)"container.extendedcrafting.compressor").build();
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
        return CompressorContainer.create(windowId, playerInventory, arg_0 -> ((CompressorTileEntity)this).isUsableByPlayer(arg_0), this.inventory, (ContainerData)new SimpleContainerData(0), this.m_58899_());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CompressorTileEntity tile) {
        boolean mark = false;
        ItemStack output = tile.inventory.getStackInSlot(0);
        ItemStack input = tile.inventory.getStackInSlot(1);
        ItemStack catalyst = tile.inventory.getStackInSlot(2);
        tile.recipeInventory.setStackInSlot(0, tile.materialStack);
        tile.recipeInventory.setStackInSlot(1, catalyst);
        if (tile.recipe == null || !tile.recipe.matches((IItemHandler)tile.recipeInventory)) {
            tile.recipe = level.m_7465_().m_44015_((RecipeType)ModRecipeTypes.COMPRESSOR.get(), tile.recipeInventory.toIInventory(), level).orElse(null);
        }
        if (!level.m_5776_()) {
            if (!input.m_41619_()) {
                int index;
                if (tile.materialStack.m_41619_() || tile.materialCount <= 0) {
                    tile.materialStack = input.m_41777_();
                    mark = true;
                }
                if ((!tile.inputLimit || tile.recipe != null && tile.materialCount < tile.recipe.getInputCount()) && (index = tile.canInsertItem(input)) > -1) {
                    tile.insertItem(index, input);
                    mark = true;
                }
            }
            if (tile.recipe != null && tile.getEnergy().getEnergyStored() > 0 && tile.materialCount >= tile.recipe.getInputCount()) {
                if (tile.progress >= tile.recipe.getPowerCost()) {
                    ItemStack result = tile.recipe.assemble((IItemHandler)tile.inventory);
                    if (StackHelper.canCombineStacks((ItemStack)result, (ItemStack)output)) {
                        tile.updateResult(result);
                        tile.progress = 0;
                        tile.materialCount -= tile.recipe.getInputCount();
                        if (tile.materialCount <= 0) {
                            tile.materialStack = ItemStack.f_41583_;
                        }
                    }
                } else {
                    tile.process(tile.recipe);
                    mark = true;
                }
            }
            if (tile.ejecting) {
                int addCount;
                MaterialInput newestInput = tile.getNewestInput();
                ItemStack newestStack = newestInput.stack;
                if (tile.materialCount > 0 && !newestStack.m_41619_() && (output.m_41619_() || StackHelper.areStacksEqual((ItemStack)newestStack, (ItemStack)output)) && (addCount = Math.min(newestInput.count, newestStack.m_41741_() - output.m_41613_())) > 0) {
                    ItemStack toAdd = StackHelper.withSize((ItemStack)newestStack, (int)addCount, (boolean)false);
                    tile.updateResult(toAdd);
                    tile.materialCount -= addCount;
                    newestInput.count -= addCount;
                    if (newestInput.count <= 0) {
                        tile.inputs.remove(tile.inputs.size() - 1);
                    }
                    if (tile.materialCount < 1) {
                        tile.materialStack = ItemStack.f_41583_;
                        tile.ejecting = false;
                    }
                    if (tile.progress > 0) {
                        tile.progress = 0;
                    }
                    if (!mark) {
                        mark = true;
                    }
                }
            }
        }
        if (tile.oldEnergy != tile.energy.getEnergyStored()) {
            tile.oldEnergy = tile.energy.getEnergyStored();
            if (!mark) {
                mark = true;
            }
        }
        if (mark) {
            tile.markDirtyAndDispatch();
        }
    }

    public static BaseItemStackHandler createInventoryHandler(Runnable onContentsChanged) {
        BaseItemStackHandler inventory = new BaseItemStackHandler(3, onContentsChanged);
        inventory.setOutputSlots(new int[]{0});
        inventory.setSlotValidator((slot, stack) -> slot == 1);
        return inventory;
    }

    public EnergyStorage getEnergy() {
        return this.energy;
    }

    public ItemStack getMaterialStack() {
        return this.materialStack;
    }

    public boolean hasMaterialStack() {
        return !this.materialStack.m_41619_();
    }

    public int getMaterialCount() {
        return this.materialCount;
    }

    public boolean isEjecting() {
        return this.ejecting;
    }

    public void toggleEjecting() {
        if (this.materialCount > 0) {
            this.ejecting = !this.ejecting;
            this.markDirtyAndDispatch();
        }
    }

    public boolean isLimitingInput() {
        return this.inputLimit;
    }

    public void toggleInputLimit() {
        this.inputLimit = !this.inputLimit;
        this.markDirtyAndDispatch();
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean hasRecipe() {
        return this.recipe != null;
    }

    public CompressorRecipe getActiveRecipe() {
        return this.recipe;
    }

    public int getEnergyRequired() {
        if (this.hasRecipe()) {
            return this.recipe.getPowerCost();
        }
        return 0;
    }

    public int getMaterialsRequired() {
        if (this.hasRecipe()) {
            return this.recipe.getInputCount();
        }
        return 0;
    }

    public List<MaterialInput> getInputs() {
        return this.inputs;
    }

    private void process(CompressorRecipe recipe) {
        int extract = recipe.getPowerRate();
        int difference = recipe.getPowerCost() - this.progress;
        if (difference < extract) {
            extract = difference;
        }
        int extracted = this.energy.extractEnergy(extract, false);
        this.progress += extracted;
    }

    private void updateResult(ItemStack stack) {
        ItemStack result = this.inventory.getStackInSlot(0);
        if (result.m_41619_()) {
            this.inventory.setStackInSlot(0, stack);
        } else {
            this.inventory.setStackInSlot(0, StackHelper.grow((ItemStack)result, (int)stack.m_41613_()));
        }
    }

    private int canInsertItem(ItemStack stack) {
        Ingredient recipeStack;
        int size = this.inputs.size();
        if (size == 0) {
            return 0;
        }
        for (int i = 0; i < size; ++i) {
            MaterialInput input = this.inputs.get(i);
            if (!StackHelper.areStacksEqual((ItemStack)stack, (ItemStack)input.stack)) continue;
            return i;
        }
        if (size < 100 && this.recipe != null && (recipeStack = (Ingredient)this.recipe.m_7527_().get(0)).test(stack)) {
            return size;
        }
        return -1;
    }

    private void insertItem(int index, ItemStack stack) {
        int consumeAmount = stack.m_41613_();
        if (this.inputLimit) {
            consumeAmount = Math.min(consumeAmount, this.recipe.getInputCount() - this.materialCount);
        }
        if (this.inputs.isEmpty() || this.inputs.size() == index) {
            this.inputs.add(new MaterialInput(stack.m_41777_(), stack.m_41613_()));
        } else {
            MaterialInput input = this.inputs.get(index);
            if (StackHelper.areStacksEqual((ItemStack)stack, (ItemStack)input.stack)) {
                input.count += stack.m_41613_();
            } else {
                this.inputs.add(new MaterialInput(stack.m_41777_(), stack.m_41613_()));
            }
        }
        stack.m_41774_(consumeAmount);
        this.materialCount += consumeAmount;
    }

    private MaterialInput getNewestInput() {
        return this.inputs.get(this.inputs.size() - 1);
    }

    private static List<MaterialInput> loadMaterialInputs(CompoundTag tag) {
        ListTag list = tag.m_128437_("Inputs", 10);
        ArrayList<MaterialInput> inputs = new ArrayList<MaterialInput>();
        for (int i = 0; i < list.size(); ++i) {
            inputs.add(MaterialInput.load(list.m_128728_(i)));
        }
        if (tag.m_128441_("MaterialStack") && inputs.isEmpty()) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("MaterialStack"));
            int count = tag.m_128451_("MaterialCount");
            if (count > 0) {
                inputs.add(new MaterialInput(stack, count));
            }
        }
        return inputs;
    }

    private static void saveMaterialInputs(CompoundTag tag, List<MaterialInput> inputs) {
        ListTag list = new ListTag();
        for (MaterialInput input : inputs) {
            list.add((Object)input.save());
        }
        tag.m_128365_("Inputs", (Tag)list);
    }

    public static class MaterialInput {
        public ItemStack stack;
        public int count;

        public MaterialInput(ItemStack stack, int count) {
            this.stack = stack;
            this.count = count;
        }

        public Component getDisplayName() {
            return Component.m_237113_((String)(this.count + "x ")).m_7220_(this.stack.m_41786_());
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("Item", (Tag)this.stack.m_41739_(new CompoundTag()));
            tag.m_128405_("Count", this.count);
            return tag;
        }

        public static MaterialInput load(CompoundTag tag) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item"));
            int count = tag.m_128451_("Count");
            return new MaterialInput(stack, count);
        }
    }
}

